/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.profile;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.device.profile.AlarmConditionFilter;
import org.thingsboard.server.common.data.device.profile.AlarmConditionFilterKey;
import org.thingsboard.server.common.data.device.profile.AlarmConditionKeyType;
import org.thingsboard.server.common.data.device.profile.DeviceProfileAlarm;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.query.ComplexFilterPredicate;
import org.thingsboard.server.common.data.query.DynamicValue;
import org.thingsboard.server.common.data.query.DynamicValueSourceType;
import org.thingsboard.server.common.data.query.KeyFilterPredicate;
import org.thingsboard.server.common.data.query.SimpleKeyFilterPredicate;

class ProfileState {
    private DeviceProfile deviceProfile;
    private final List<DeviceProfileAlarm> alarmSettings = new CopyOnWriteArrayList<DeviceProfileAlarm>();
    private final Set<AlarmConditionFilterKey> entityKeys = ConcurrentHashMap.newKeySet();
    private final Map<String, Map<AlarmSeverity, Set<AlarmConditionFilterKey>>> alarmCreateKeys = new HashMap<String, Map<AlarmSeverity, Set<AlarmConditionFilterKey>>>();
    private final Map<String, Set<AlarmConditionFilterKey>> alarmClearKeys = new HashMap<String, Set<AlarmConditionFilterKey>>();

    ProfileState(DeviceProfile deviceProfile) {
        this.updateDeviceProfile(deviceProfile);
    }

    void updateDeviceProfile(DeviceProfile deviceProfile) {
        this.deviceProfile = deviceProfile;
        this.alarmSettings.clear();
        this.alarmCreateKeys.clear();
        this.alarmClearKeys.clear();
        this.entityKeys.clear();
        if (deviceProfile.getProfileData().getAlarms() != null) {
            this.alarmSettings.addAll(deviceProfile.getProfileData().getAlarms());
            for (DeviceProfileAlarm alarm : deviceProfile.getProfileData().getAlarms()) {
                Map createAlarmKeys = this.alarmCreateKeys.computeIfAbsent(alarm.getId(), id -> new HashMap());
                alarm.getCreateRules().forEach((severity, alarmRule) -> {
                    Set ruleKeys = createAlarmKeys.computeIfAbsent(severity, id -> new HashSet());
                    for (AlarmConditionFilter keyFilter : alarmRule.getCondition().getCondition()) {
                        this.entityKeys.add(keyFilter.getKey());
                        ruleKeys.add(keyFilter.getKey());
                        this.addDynamicValuesRecursively(keyFilter.getPredicate(), this.entityKeys, ruleKeys);
                    }
                });
                if (alarm.getClearRule() == null) continue;
                Set clearAlarmKeys = this.alarmClearKeys.computeIfAbsent(alarm.getId(), id -> new HashSet());
                for (AlarmConditionFilter keyFilter : alarm.getClearRule().getCondition().getCondition()) {
                    this.entityKeys.add(keyFilter.getKey());
                    clearAlarmKeys.add(keyFilter.getKey());
                    this.addDynamicValuesRecursively(keyFilter.getPredicate(), this.entityKeys, clearAlarmKeys);
                }
            }
        }
    }

    private void addDynamicValuesRecursively(KeyFilterPredicate predicate, Set<AlarmConditionFilterKey> entityKeys, Set<AlarmConditionFilterKey> ruleKeys) {
        switch (predicate.getType()) {
            case STRING: 
            case NUMERIC: 
            case BOOLEAN: {
                DynamicValue value = ((SimpleKeyFilterPredicate)predicate).getValue().getDynamicValue();
                if (value == null || value.getSourceType() != DynamicValueSourceType.CURRENT_TENANT && value.getSourceType() != DynamicValueSourceType.CURRENT_CUSTOMER && value.getSourceType() != DynamicValueSourceType.CURRENT_DEVICE) break;
                AlarmConditionFilterKey entityKey = new AlarmConditionFilterKey(AlarmConditionKeyType.ATTRIBUTE, value.getSourceAttribute());
                entityKeys.add(entityKey);
                ruleKeys.add(entityKey);
                break;
            }
            case COMPLEX: {
                for (KeyFilterPredicate child : ((ComplexFilterPredicate)predicate).getPredicates()) {
                    this.addDynamicValuesRecursively(child, entityKeys, ruleKeys);
                }
                break;
            }
        }
    }

    DeviceProfileId getProfileId() {
        return (DeviceProfileId)this.deviceProfile.getId();
    }

    Set<AlarmConditionFilterKey> getCreateAlarmKeys(String id, AlarmSeverity severity) {
        Map<AlarmSeverity, Set<AlarmConditionFilterKey>> sKeys = this.alarmCreateKeys.get(id);
        if (sKeys == null) {
            return Collections.emptySet();
        }
        Set<AlarmConditionFilterKey> keys = sKeys.get(severity);
        if (keys == null) {
            return Collections.emptySet();
        }
        return keys;
    }

    Set<AlarmConditionFilterKey> getClearAlarmKeys(String id) {
        Set<AlarmConditionFilterKey> keys = this.alarmClearKeys.get(id);
        if (keys == null) {
            return Collections.emptySet();
        }
        return keys;
    }

    List<DeviceProfileAlarm> getAlarmSettings() {
        return this.alarmSettings;
    }

    Set<AlarmConditionFilterKey> getEntityKeys() {
        return this.entityKeys;
    }
}

