/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.profile;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.profile.DeviceState;
import org.thingsboard.rule.engine.profile.DynamicPredicateValueCtx;
import org.thingsboard.rule.engine.profile.EntityKeyValue;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.KvEntry;

public class DynamicPredicateValueCtxImpl
implements DynamicPredicateValueCtx {
    private static final Logger log = LoggerFactory.getLogger(DynamicPredicateValueCtxImpl.class);
    private final TenantId tenantId;
    private CustomerId customerId;
    private final DeviceId deviceId;
    private final TbContext ctx;

    public DynamicPredicateValueCtxImpl(TenantId tenantId, DeviceId deviceId, TbContext ctx) {
        this.tenantId = tenantId;
        this.deviceId = deviceId;
        this.ctx = ctx;
        this.resetCustomer();
    }

    @Override
    public EntityKeyValue getTenantValue(String key) {
        return this.getValue((EntityId)this.tenantId, key);
    }

    @Override
    public EntityKeyValue getCustomerValue(String key) {
        return this.customerId == null || this.customerId.isNullUid() ? null : this.getValue((EntityId)this.customerId, key);
    }

    @Override
    public void resetCustomer() {
        Device device = this.ctx.getDeviceService().findDeviceById(this.tenantId, this.deviceId);
        if (device != null) {
            this.customerId = device.getCustomerId();
        }
    }

    private EntityKeyValue getValue(EntityId entityId, String key) {
        try {
            Optional entry = (Optional)this.ctx.getAttributesService().find(this.tenantId, entityId, "SERVER_SCOPE", key).get();
            if (entry.isPresent()) {
                return DeviceState.toEntityValue((KvEntry)entry.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Failed to get attribute by key: {} for {}: [{}]", new Object[]{key, entityId.getEntityType(), entityId.getId()});
        }
        return null;
    }
}

