/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.profile;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.thingsboard.rule.engine.profile.EntityKeyValue;
import org.thingsboard.server.common.data.device.profile.AlarmConditionFilterKey;
import org.thingsboard.server.common.data.device.profile.AlarmConditionKeyType;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;

class DataSnapshot {
    private volatile boolean ready;
    private long ts;
    private final Set<AlarmConditionFilterKey> keys;
    private final Map<AlarmConditionFilterKey, EntityKeyValue> values = new ConcurrentHashMap<AlarmConditionFilterKey, EntityKeyValue>();

    DataSnapshot(Set<AlarmConditionFilterKey> entityKeysToFetch) {
        this.keys = entityKeysToFetch;
    }

    static AlarmConditionFilterKey toConditionKey(EntityKey key) {
        return new AlarmConditionFilterKey(DataSnapshot.toConditionKeyType(key.getType()), key.getKey());
    }

    static AlarmConditionKeyType toConditionKeyType(EntityKeyType keyType) {
        switch (keyType) {
            case ATTRIBUTE: 
            case SERVER_ATTRIBUTE: 
            case SHARED_ATTRIBUTE: 
            case CLIENT_ATTRIBUTE: {
                return AlarmConditionKeyType.ATTRIBUTE;
            }
            case TIME_SERIES: {
                return AlarmConditionKeyType.TIME_SERIES;
            }
            case ENTITY_FIELD: {
                return AlarmConditionKeyType.ENTITY_FIELD;
            }
        }
        throw new RuntimeException("Not supported entity key: " + keyType.name());
    }

    void removeValue(EntityKey key) {
        this.values.remove(DataSnapshot.toConditionKey(key));
    }

    boolean putValue(AlarmConditionFilterKey key, long newTs, EntityKeyValue value) {
        return this.putIfKeyExists(key, value, this.ts != newTs);
    }

    private boolean putIfKeyExists(AlarmConditionFilterKey key, EntityKeyValue value, boolean updateOfTs) {
        if (this.keys.contains(key)) {
            EntityKeyValue oldValue = this.values.put(key, value);
            if (updateOfTs) {
                return true;
            }
            return oldValue == null || !oldValue.equals(value);
        }
        return false;
    }

    EntityKeyValue getValue(AlarmConditionFilterKey key) {
        return this.values.get(key);
    }

    public long getTs() {
        return this.ts;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }
}

