/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.profile;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.profile.AlarmEvalResult;
import org.thingsboard.rule.engine.profile.DataSnapshot;
import org.thingsboard.rule.engine.profile.DynamicPredicateValueCtx;
import org.thingsboard.rule.engine.profile.EntityKeyValue;
import org.thingsboard.rule.engine.profile.state.PersistedAlarmRuleState;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.device.profile.AlarmCondition;
import org.thingsboard.server.common.data.device.profile.AlarmConditionFilter;
import org.thingsboard.server.common.data.device.profile.AlarmConditionFilterKey;
import org.thingsboard.server.common.data.device.profile.AlarmConditionKeyType;
import org.thingsboard.server.common.data.device.profile.AlarmConditionSpec;
import org.thingsboard.server.common.data.device.profile.AlarmRule;
import org.thingsboard.server.common.data.device.profile.CustomTimeSchedule;
import org.thingsboard.server.common.data.device.profile.CustomTimeScheduleItem;
import org.thingsboard.server.common.data.device.profile.DurationAlarmConditionSpec;
import org.thingsboard.server.common.data.device.profile.RepeatingAlarmConditionSpec;
import org.thingsboard.server.common.data.device.profile.SimpleAlarmConditionSpec;
import org.thingsboard.server.common.data.device.profile.SpecificTimeSchedule;
import org.thingsboard.server.common.data.query.BooleanFilterPredicate;
import org.thingsboard.server.common.data.query.ComplexFilterPredicate;
import org.thingsboard.server.common.data.query.FilterPredicateValue;
import org.thingsboard.server.common.data.query.KeyFilterPredicate;
import org.thingsboard.server.common.data.query.NumericFilterPredicate;
import org.thingsboard.server.common.data.query.StringFilterPredicate;
import org.thingsboard.server.common.msg.tools.SchedulerUtils;

class AlarmRuleState {
    private static final Logger log = LoggerFactory.getLogger(AlarmRuleState.class);
    private final AlarmSeverity severity;
    private final AlarmRule alarmRule;
    private final AlarmConditionSpec spec;
    private final long requiredDurationInMs;
    private final long requiredRepeats;
    private final Set<AlarmConditionFilterKey> entityKeys;
    private PersistedAlarmRuleState state;
    private boolean updateFlag;
    private final DynamicPredicateValueCtx dynamicPredicateValueCtx;

    AlarmRuleState(AlarmSeverity severity, AlarmRule alarmRule, Set<AlarmConditionFilterKey> entityKeys, PersistedAlarmRuleState state, DynamicPredicateValueCtx dynamicPredicateValueCtx) {
        this.severity = severity;
        this.alarmRule = alarmRule;
        this.entityKeys = entityKeys;
        this.state = state != null ? state : new PersistedAlarmRuleState(0L, 0L, 0L);
        this.spec = this.getSpec(alarmRule);
        long requiredDurationInMs = 0L;
        long requiredRepeats = 0L;
        switch (this.spec.getType()) {
            case DURATION: {
                DurationAlarmConditionSpec duration = (DurationAlarmConditionSpec)this.spec;
                requiredDurationInMs = duration.getUnit().toMillis(duration.getValue());
                break;
            }
            case REPEATING: {
                RepeatingAlarmConditionSpec repeating = (RepeatingAlarmConditionSpec)this.spec;
                requiredRepeats = repeating.getCount();
            }
        }
        this.requiredDurationInMs = requiredDurationInMs;
        this.requiredRepeats = requiredRepeats;
        this.dynamicPredicateValueCtx = dynamicPredicateValueCtx;
    }

    public boolean validateTsUpdate(Set<AlarmConditionFilterKey> changedKeys) {
        for (AlarmConditionFilterKey key : changedKeys) {
            if (!this.entityKeys.contains(key)) continue;
            return true;
        }
        return false;
    }

    public boolean validateAttrUpdate(Set<AlarmConditionFilterKey> changedKeys) {
        for (AlarmConditionFilterKey key : this.entityKeys) {
            if (!key.getType().equals((Object)AlarmConditionKeyType.TIME_SERIES)) continue;
            return false;
        }
        for (AlarmConditionFilterKey key : changedKeys) {
            if (!this.entityKeys.contains(key)) continue;
            return true;
        }
        return false;
    }

    public AlarmConditionSpec getSpec(AlarmRule alarmRule) {
        AlarmConditionSpec spec = alarmRule.getCondition().getSpec();
        if (spec == null) {
            spec = new SimpleAlarmConditionSpec();
        }
        return spec;
    }

    public boolean checkUpdate() {
        if (this.updateFlag) {
            this.updateFlag = false;
            return true;
        }
        return false;
    }

    public AlarmEvalResult eval(DataSnapshot data) {
        boolean active = this.isActive(data.getTs());
        switch (this.spec.getType()) {
            case SIMPLE: {
                return active && this.eval(this.alarmRule.getCondition(), data) ? AlarmEvalResult.TRUE : AlarmEvalResult.FALSE;
            }
            case DURATION: {
                return this.evalDuration(data, active);
            }
            case REPEATING: {
                return this.evalRepeating(data, active);
            }
        }
        return AlarmEvalResult.FALSE;
    }

    private boolean isActive(long eventTs) {
        if (eventTs == 0L) {
            eventTs = System.currentTimeMillis();
        }
        if (this.alarmRule.getSchedule() == null) {
            return true;
        }
        switch (this.alarmRule.getSchedule().getType()) {
            case ANY_TIME: {
                return true;
            }
            case SPECIFIC_TIME: {
                return this.isActiveSpecific((SpecificTimeSchedule)this.alarmRule.getSchedule(), eventTs);
            }
            case CUSTOM: {
                return this.isActiveCustom((CustomTimeSchedule)this.alarmRule.getSchedule(), eventTs);
            }
        }
        throw new RuntimeException("Unsupported schedule type: " + this.alarmRule.getSchedule().getType());
    }

    private boolean isActiveSpecific(SpecificTimeSchedule schedule, long eventTs) {
        ZoneId zoneId = SchedulerUtils.getZoneId((String)schedule.getTimezone());
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(eventTs), zoneId);
        if (schedule.getDaysOfWeek().size() != 7) {
            int dayOfWeek = zdt.getDayOfWeek().getValue();
            if (!schedule.getDaysOfWeek().contains(dayOfWeek)) {
                return false;
            }
        }
        return this.isActive(eventTs, zoneId, zdt, schedule.getStartsOn(), schedule.getEndsOn());
    }

    private boolean isActiveCustom(CustomTimeSchedule schedule, long eventTs) {
        ZoneId zoneId = SchedulerUtils.getZoneId((String)schedule.getTimezone());
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(eventTs), zoneId);
        int dayOfWeek = zdt.toLocalDate().getDayOfWeek().getValue();
        for (CustomTimeScheduleItem item : schedule.getItems()) {
            if (item.getDayOfWeek() != dayOfWeek) continue;
            if (item.isEnabled()) {
                return this.isActive(eventTs, zoneId, zdt, item.getStartsOn(), item.getEndsOn());
            }
            return false;
        }
        return false;
    }

    private boolean isActive(long eventTs, ZoneId zoneId, ZonedDateTime zdt, long startsOn, long endsOn) {
        long startOfDay = zdt.toLocalDate().atStartOfDay(zoneId).toInstant().toEpochMilli();
        long msFromStartOfDay = eventTs - startOfDay;
        if (startsOn <= endsOn) {
            return startsOn <= msFromStartOfDay && endsOn > msFromStartOfDay;
        }
        return startsOn < msFromStartOfDay || 0L < msFromStartOfDay && msFromStartOfDay < endsOn;
    }

    public void clear() {
        if (this.state.getEventCount() > 0L || this.state.getLastEventTs() > 0L || this.state.getDuration() > 0L) {
            this.state.setEventCount(0L);
            this.state.setLastEventTs(0L);
            this.state.setDuration(0L);
            this.updateFlag = true;
        }
    }

    private AlarmEvalResult evalRepeating(DataSnapshot data, boolean active) {
        if (active && this.eval(this.alarmRule.getCondition(), data)) {
            this.state.setEventCount(this.state.getEventCount() + 1L);
            this.updateFlag = true;
            return this.state.getEventCount() >= this.requiredRepeats ? AlarmEvalResult.TRUE : AlarmEvalResult.NOT_YET_TRUE;
        }
        return AlarmEvalResult.FALSE;
    }

    private AlarmEvalResult evalDuration(DataSnapshot data, boolean active) {
        if (active && this.eval(this.alarmRule.getCondition(), data)) {
            if (this.state.getLastEventTs() > 0L) {
                if (data.getTs() > this.state.getLastEventTs()) {
                    this.state.setDuration(this.state.getDuration() + (data.getTs() - this.state.getLastEventTs()));
                    this.state.setLastEventTs(data.getTs());
                    this.updateFlag = true;
                }
            } else {
                this.state.setLastEventTs(data.getTs());
                this.state.setDuration(0L);
                this.updateFlag = true;
            }
            return this.state.getDuration() > this.requiredDurationInMs ? AlarmEvalResult.TRUE : AlarmEvalResult.NOT_YET_TRUE;
        }
        return AlarmEvalResult.FALSE;
    }

    public AlarmEvalResult eval(long ts) {
        switch (this.spec.getType()) {
            case REPEATING: 
            case SIMPLE: {
                return AlarmEvalResult.NOT_YET_TRUE;
            }
            case DURATION: {
                if (this.requiredDurationInMs <= 0L || this.state.getLastEventTs() <= 0L || ts <= this.state.getLastEventTs()) break;
                long duration = this.state.getDuration() + (ts - this.state.getLastEventTs());
                if (this.isActive(ts)) {
                    return duration > this.requiredDurationInMs ? AlarmEvalResult.TRUE : AlarmEvalResult.NOT_YET_TRUE;
                }
                return AlarmEvalResult.FALSE;
            }
        }
        return AlarmEvalResult.FALSE;
    }

    private boolean eval(AlarmCondition condition, DataSnapshot data) {
        boolean eval = true;
        for (AlarmConditionFilter filter : condition.getCondition()) {
            EntityKeyValue value;
            if (filter.getKey().getType().equals((Object)AlarmConditionKeyType.CONSTANT)) {
                try {
                    value = this.getConstantValue(filter);
                }
                catch (RuntimeException e) {
                    log.warn("Failed to parse constant value from filter: {}", (Object)filter, (Object)e);
                    value = null;
                }
            } else {
                value = data.getValue(filter.getKey());
            }
            if (value == null) {
                return false;
            }
            eval = eval && this.eval(data, value, filter.getPredicate());
        }
        return eval;
    }

    private EntityKeyValue getConstantValue(AlarmConditionFilter filter) {
        EntityKeyValue value = new EntityKeyValue();
        String valueStr = filter.getValue().toString();
        switch (filter.getValueType()) {
            case STRING: {
                value.setStrValue(valueStr);
                break;
            }
            case DATE_TIME: {
                value.setLngValue(Long.valueOf(valueStr));
                break;
            }
            case NUMERIC: {
                value.setDblValue(Double.valueOf(valueStr));
                break;
            }
            case BOOLEAN: {
                value.setBoolValue(Boolean.valueOf(valueStr));
            }
        }
        return value;
    }

    private boolean eval(DataSnapshot data, EntityKeyValue value, KeyFilterPredicate predicate) {
        switch (predicate.getType()) {
            case STRING: {
                return this.evalStrPredicate(data, value, (StringFilterPredicate)predicate);
            }
            case NUMERIC: {
                return this.evalNumPredicate(data, value, (NumericFilterPredicate)predicate);
            }
            case BOOLEAN: {
                return this.evalBoolPredicate(data, value, (BooleanFilterPredicate)predicate);
            }
            case COMPLEX: {
                return this.evalComplexPredicate(data, value, (ComplexFilterPredicate)predicate);
            }
        }
        return false;
    }

    private boolean evalComplexPredicate(DataSnapshot data, EntityKeyValue ekv, ComplexFilterPredicate predicate) {
        switch (predicate.getOperation()) {
            case OR: {
                for (KeyFilterPredicate kfp : predicate.getPredicates()) {
                    if (!this.eval(data, ekv, kfp)) continue;
                    return true;
                }
                return false;
            }
            case AND: {
                for (KeyFilterPredicate kfp : predicate.getPredicates()) {
                    if (this.eval(data, ekv, kfp)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new RuntimeException("Operation not supported: " + predicate.getOperation());
    }

    private boolean evalBoolPredicate(DataSnapshot data, EntityKeyValue ekv, BooleanFilterPredicate predicate) {
        Boolean val = AlarmRuleState.getBoolValue(ekv);
        if (val == null) {
            return false;
        }
        Boolean predicateValue = this.getPredicateValue(data, predicate.getValue(), AlarmRuleState::getBoolValue);
        switch (predicate.getOperation()) {
            case EQUAL: {
                return val.equals(predicateValue);
            }
            case NOT_EQUAL: {
                return !val.equals(predicateValue);
            }
        }
        throw new RuntimeException("Operation not supported: " + predicate.getOperation());
    }

    private boolean evalNumPredicate(DataSnapshot data, EntityKeyValue ekv, NumericFilterPredicate predicate) {
        Double val = AlarmRuleState.getDblValue(ekv);
        if (val == null) {
            return false;
        }
        Double predicateValue = this.getPredicateValue(data, predicate.getValue(), AlarmRuleState::getDblValue);
        switch (predicate.getOperation()) {
            case NOT_EQUAL: {
                return !val.equals(predicateValue);
            }
            case EQUAL: {
                return val.equals(predicateValue);
            }
            case GREATER: {
                return val > predicateValue;
            }
            case GREATER_OR_EQUAL: {
                return val >= predicateValue;
            }
            case LESS: {
                return val < predicateValue;
            }
            case LESS_OR_EQUAL: {
                return val <= predicateValue;
            }
        }
        throw new RuntimeException("Operation not supported: " + predicate.getOperation());
    }

    private boolean evalStrPredicate(DataSnapshot data, EntityKeyValue ekv, StringFilterPredicate predicate) {
        String val = AlarmRuleState.getStrValue(ekv);
        if (val == null) {
            return false;
        }
        String predicateValue = this.getPredicateValue(data, predicate.getValue(), AlarmRuleState::getStrValue);
        if (predicate.isIgnoreCase()) {
            val = val.toLowerCase();
            predicateValue = predicateValue.toLowerCase();
        }
        switch (predicate.getOperation()) {
            case CONTAINS: {
                return val.contains(predicateValue);
            }
            case EQUAL: {
                return val.equals(predicateValue);
            }
            case STARTS_WITH: {
                return val.startsWith(predicateValue);
            }
            case ENDS_WITH: {
                return val.endsWith(predicateValue);
            }
            case NOT_EQUAL: {
                return !val.equals(predicateValue);
            }
            case NOT_CONTAINS: {
                return !val.contains(predicateValue);
            }
        }
        throw new RuntimeException("Operation not supported: " + predicate.getOperation());
    }

    private <T> T getPredicateValue(DataSnapshot data, FilterPredicateValue<T> value, Function<EntityKeyValue, T> transformFunction) {
        T result;
        EntityKeyValue ekv = this.getDynamicPredicateValue(data, value);
        if (ekv != null && (result = transformFunction.apply(ekv)) != null) {
            return result;
        }
        return (T)value.getDefaultValue();
    }

    private <T> EntityKeyValue getDynamicPredicateValue(DataSnapshot data, FilterPredicateValue<T> value) {
        EntityKeyValue ekv = null;
        if (value.getDynamicValue() != null) {
            switch (value.getDynamicValue().getSourceType()) {
                case CURRENT_DEVICE: {
                    ekv = data.getValue(new AlarmConditionFilterKey(AlarmConditionKeyType.ATTRIBUTE, value.getDynamicValue().getSourceAttribute()));
                    if (ekv != null || !value.getDynamicValue().isInherit()) break;
                }
                case CURRENT_CUSTOMER: {
                    ekv = this.dynamicPredicateValueCtx.getCustomerValue(value.getDynamicValue().getSourceAttribute());
                    if (ekv != null || !value.getDynamicValue().isInherit()) break;
                }
                case CURRENT_TENANT: {
                    ekv = this.dynamicPredicateValueCtx.getTenantValue(value.getDynamicValue().getSourceAttribute());
                }
            }
        }
        return ekv;
    }

    private static String getStrValue(EntityKeyValue ekv) {
        switch (ekv.getDataType()) {
            case LONG: {
                return ekv.getLngValue() != null ? ekv.getLngValue().toString() : null;
            }
            case DOUBLE: {
                return ekv.getDblValue() != null ? ekv.getDblValue().toString() : null;
            }
            case BOOLEAN: {
                return ekv.getBoolValue() != null ? ekv.getBoolValue().toString() : null;
            }
            case STRING: {
                return ekv.getStrValue();
            }
            case JSON: {
                return ekv.getJsonValue();
            }
        }
        return null;
    }

    private static Double getDblValue(EntityKeyValue ekv) {
        switch (ekv.getDataType()) {
            case LONG: {
                return ekv.getLngValue() != null ? Double.valueOf(ekv.getLngValue().doubleValue()) : null;
            }
            case DOUBLE: {
                return ekv.getDblValue() != null ? ekv.getDblValue() : null;
            }
            case BOOLEAN: {
                return ekv.getBoolValue() != null ? Double.valueOf(ekv.getBoolValue() != false ? 1.0 : 0.0) : null;
            }
            case STRING: {
                try {
                    return Double.parseDouble(ekv.getStrValue());
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
            case JSON: {
                try {
                    return Double.parseDouble(ekv.getJsonValue());
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
        }
        return null;
    }

    private static Boolean getBoolValue(EntityKeyValue ekv) {
        switch (ekv.getDataType()) {
            case LONG: {
                return ekv.getLngValue() != null ? Boolean.valueOf(ekv.getLngValue() > 0L) : null;
            }
            case DOUBLE: {
                return ekv.getDblValue() != null ? Boolean.valueOf(ekv.getDblValue() > 0.0) : null;
            }
            case BOOLEAN: {
                return ekv.getBoolValue();
            }
            case STRING: {
                try {
                    return Boolean.parseBoolean(ekv.getStrValue());
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
            case JSON: {
                try {
                    return Boolean.parseBoolean(ekv.getJsonValue());
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public AlarmSeverity getSeverity() {
        return this.severity;
    }

    public AlarmRule getAlarmRule() {
        return this.alarmRule;
    }

    public AlarmConditionSpec getSpec() {
        return this.spec;
    }

    public long getRequiredDurationInMs() {
        return this.requiredDurationInMs;
    }

    public long getRequiredRepeats() {
        return this.requiredRepeats;
    }

    public Set<AlarmConditionFilterKey> getEntityKeys() {
        return this.entityKeys;
    }

    public PersistedAlarmRuleState getState() {
        return this.state;
    }

    public boolean isUpdateFlag() {
        return this.updateFlag;
    }

    public DynamicPredicateValueCtx getDynamicPredicateValueCtx() {
        return this.dynamicPredicateValueCtx;
    }

    public void setState(PersistedAlarmRuleState state) {
        this.state = state;
    }

    public void setUpdateFlag(boolean updateFlag) {
        this.updateFlag = updateFlag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmRuleState)) {
            return false;
        }
        AlarmRuleState other = (AlarmRuleState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRequiredDurationInMs() != other.getRequiredDurationInMs()) {
            return false;
        }
        if (this.getRequiredRepeats() != other.getRequiredRepeats()) {
            return false;
        }
        if (this.isUpdateFlag() != other.isUpdateFlag()) {
            return false;
        }
        AlarmSeverity this$severity = this.getSeverity();
        AlarmSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
            return false;
        }
        AlarmRule this$alarmRule = this.getAlarmRule();
        AlarmRule other$alarmRule = other.getAlarmRule();
        if (this$alarmRule == null ? other$alarmRule != null : !this$alarmRule.equals(other$alarmRule)) {
            return false;
        }
        AlarmConditionSpec this$spec = this.getSpec();
        AlarmConditionSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        Set<AlarmConditionFilterKey> this$entityKeys = this.getEntityKeys();
        Set<AlarmConditionFilterKey> other$entityKeys = other.getEntityKeys();
        if (this$entityKeys == null ? other$entityKeys != null : !((Object)this$entityKeys).equals(other$entityKeys)) {
            return false;
        }
        PersistedAlarmRuleState this$state = this.getState();
        PersistedAlarmRuleState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        DynamicPredicateValueCtx this$dynamicPredicateValueCtx = this.getDynamicPredicateValueCtx();
        DynamicPredicateValueCtx other$dynamicPredicateValueCtx = other.getDynamicPredicateValueCtx();
        return !(this$dynamicPredicateValueCtx == null ? other$dynamicPredicateValueCtx != null : !this$dynamicPredicateValueCtx.equals(other$dynamicPredicateValueCtx));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmRuleState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $requiredDurationInMs = this.getRequiredDurationInMs();
        result = result * 59 + (int)($requiredDurationInMs >>> 32 ^ $requiredDurationInMs);
        long $requiredRepeats = this.getRequiredRepeats();
        result = result * 59 + (int)($requiredRepeats >>> 32 ^ $requiredRepeats);
        result = result * 59 + (this.isUpdateFlag() ? 79 : 97);
        AlarmSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        AlarmRule $alarmRule = this.getAlarmRule();
        result = result * 59 + ($alarmRule == null ? 43 : $alarmRule.hashCode());
        AlarmConditionSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        Set<AlarmConditionFilterKey> $entityKeys = this.getEntityKeys();
        result = result * 59 + ($entityKeys == null ? 43 : ((Object)$entityKeys).hashCode());
        PersistedAlarmRuleState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        DynamicPredicateValueCtx $dynamicPredicateValueCtx = this.getDynamicPredicateValueCtx();
        result = result * 59 + ($dynamicPredicateValueCtx == null ? 43 : $dynamicPredicateValueCtx.hashCode());
        return result;
    }

    public String toString() {
        return "AlarmRuleState(severity=" + this.getSeverity() + ", alarmRule=" + this.getAlarmRule() + ", spec=" + this.getSpec() + ", requiredDurationInMs=" + this.getRequiredDurationInMs() + ", requiredRepeats=" + this.getRequiredRepeats() + ", entityKeys=" + this.getEntityKeys() + ", state=" + this.getState() + ", updateFlag=" + this.isUpdateFlag() + ", dynamicPredicateValueCtx=" + this.getDynamicPredicateValueCtx() + ")";
    }
}

