/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.mqtt.azure;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.AzureIotHubUtil;
import org.thingsboard.rule.engine.credentials.CertPemCredentials;
import org.thingsboard.rule.engine.credentials.CredentialsType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AzureIotHubSasCredentials
extends CertPemCredentials {
    private static final Logger log = LoggerFactory.getLogger(AzureIotHubSasCredentials.class);
    private String sasKey;

    @Override
    public SslContext initSslContext() {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            if (this.caCert == null || this.caCert.isEmpty()) {
                this.caCert = AzureIotHubUtil.getDefaultCaCert();
            }
            return SslContextBuilder.forClient().trustManager(this.createAndInitTrustManagerFactory()).clientAuth(ClientAuth.REQUIRE).build();
        }
        catch (Exception e) {
            log.error("[{}] Creating TLS factory failed!", (Object)this.caCert, (Object)e);
            throw new RuntimeException("Creating TLS factory failed!", e);
        }
    }

    @Override
    public CredentialsType getType() {
        return CredentialsType.SAS;
    }

    public String getSasKey() {
        return this.sasKey;
    }

    public void setSasKey(String sasKey) {
        this.sasKey = sasKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureIotHubSasCredentials)) {
            return false;
        }
        AzureIotHubSasCredentials other = (AzureIotHubSasCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sasKey = this.getSasKey();
        String other$sasKey = other.getSasKey();
        return !(this$sasKey == null ? other$sasKey != null : !this$sasKey.equals(other$sasKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AzureIotHubSasCredentials;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sasKey = this.getSasKey();
        result = result * 59 + ($sasKey == null ? 43 : $sasKey.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AzureIotHubSasCredentials(sasKey=" + this.getSasKey() + ")";
    }
}

