/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.mqtt;

import org.thingsboard.rule.engine.api.NodeConfiguration;
import org.thingsboard.rule.engine.credentials.AnonymousCredentials;
import org.thingsboard.rule.engine.credentials.ClientCredentials;

public class TbMqttNodeConfiguration
implements NodeConfiguration<TbMqttNodeConfiguration> {
    private String topicPattern;
    private String host;
    private int port;
    private int connectTimeoutSec;
    private String clientId;
    private boolean cleanSession;
    private boolean ssl;
    private ClientCredentials credentials;

    public TbMqttNodeConfiguration defaultConfiguration() {
        TbMqttNodeConfiguration configuration = new TbMqttNodeConfiguration();
        configuration.setTopicPattern("my-topic");
        configuration.setHost("localhost");
        configuration.setPort(1883);
        configuration.setConnectTimeoutSec(10);
        configuration.setCleanSession(true);
        configuration.setSsl(false);
        configuration.setCredentials(new AnonymousCredentials());
        return configuration;
    }

    public String getTopicPattern() {
        return this.topicPattern;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getConnectTimeoutSec() {
        return this.connectTimeoutSec;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public ClientCredentials getCredentials() {
        return this.credentials;
    }

    public void setTopicPattern(String topicPattern) {
        this.topicPattern = topicPattern;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConnectTimeoutSec(int connectTimeoutSec) {
        this.connectTimeoutSec = connectTimeoutSec;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setCredentials(ClientCredentials credentials) {
        this.credentials = credentials;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbMqttNodeConfiguration)) {
            return false;
        }
        TbMqttNodeConfiguration other = (TbMqttNodeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getConnectTimeoutSec() != other.getConnectTimeoutSec()) {
            return false;
        }
        if (this.isCleanSession() != other.isCleanSession()) {
            return false;
        }
        if (this.isSsl() != other.isSsl()) {
            return false;
        }
        String this$topicPattern = this.getTopicPattern();
        String other$topicPattern = other.getTopicPattern();
        if (this$topicPattern == null ? other$topicPattern != null : !this$topicPattern.equals(other$topicPattern)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        ClientCredentials this$credentials = this.getCredentials();
        ClientCredentials other$credentials = other.getCredentials();
        return !(this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbMqttNodeConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getConnectTimeoutSec();
        result = result * 59 + (this.isCleanSession() ? 79 : 97);
        result = result * 59 + (this.isSsl() ? 79 : 97);
        String $topicPattern = this.getTopicPattern();
        result = result * 59 + ($topicPattern == null ? 43 : $topicPattern.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        ClientCredentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        return result;
    }

    public String toString() {
        return "TbMqttNodeConfiguration(topicPattern=" + this.getTopicPattern() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", connectTimeoutSec=" + this.getConnectTimeoutSec() + ", clientId=" + this.getClientId() + ", cleanSession=" + this.isCleanSession() + ", ssl=" + this.isSsl() + ", credentials=" + this.getCredentials() + ")";
    }
}

