/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.thingsboard.rule.engine.api.NodeConfiguration;

public class TbGetTelemetryNodeConfiguration
implements NodeConfiguration<TbGetTelemetryNodeConfiguration> {
    public static final String FETCH_MODE_FIRST = "FIRST";
    public static final String FETCH_MODE_LAST = "LAST";
    public static final String FETCH_MODE_ALL = "ALL";
    public static final int MAX_FETCH_SIZE = 1000;
    private int startInterval;
    private int endInterval;
    private String startIntervalPattern;
    private String endIntervalPattern;
    private boolean useMetadataIntervalPatterns;
    private String startIntervalTimeUnit;
    private String endIntervalTimeUnit;
    private String fetchMode;
    private String orderBy;
    private int limit;
    private List<String> latestTsKeyNames;

    public TbGetTelemetryNodeConfiguration defaultConfiguration() {
        TbGetTelemetryNodeConfiguration configuration = new TbGetTelemetryNodeConfiguration();
        configuration.setLatestTsKeyNames(Collections.emptyList());
        configuration.setFetchMode(FETCH_MODE_FIRST);
        configuration.setStartIntervalTimeUnit(TimeUnit.MINUTES.name());
        configuration.setStartInterval(2);
        configuration.setEndIntervalTimeUnit(TimeUnit.MINUTES.name());
        configuration.setEndInterval(1);
        configuration.setUseMetadataIntervalPatterns(false);
        configuration.setStartIntervalPattern("");
        configuration.setEndIntervalPattern("");
        configuration.setOrderBy("ASC");
        configuration.setLimit(1000);
        return configuration;
    }

    public int getStartInterval() {
        return this.startInterval;
    }

    public int getEndInterval() {
        return this.endInterval;
    }

    public String getStartIntervalPattern() {
        return this.startIntervalPattern;
    }

    public String getEndIntervalPattern() {
        return this.endIntervalPattern;
    }

    public boolean isUseMetadataIntervalPatterns() {
        return this.useMetadataIntervalPatterns;
    }

    public String getStartIntervalTimeUnit() {
        return this.startIntervalTimeUnit;
    }

    public String getEndIntervalTimeUnit() {
        return this.endIntervalTimeUnit;
    }

    public String getFetchMode() {
        return this.fetchMode;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public int getLimit() {
        return this.limit;
    }

    public List<String> getLatestTsKeyNames() {
        return this.latestTsKeyNames;
    }

    public void setStartInterval(int startInterval) {
        this.startInterval = startInterval;
    }

    public void setEndInterval(int endInterval) {
        this.endInterval = endInterval;
    }

    public void setStartIntervalPattern(String startIntervalPattern) {
        this.startIntervalPattern = startIntervalPattern;
    }

    public void setEndIntervalPattern(String endIntervalPattern) {
        this.endIntervalPattern = endIntervalPattern;
    }

    public void setUseMetadataIntervalPatterns(boolean useMetadataIntervalPatterns) {
        this.useMetadataIntervalPatterns = useMetadataIntervalPatterns;
    }

    public void setStartIntervalTimeUnit(String startIntervalTimeUnit) {
        this.startIntervalTimeUnit = startIntervalTimeUnit;
    }

    public void setEndIntervalTimeUnit(String endIntervalTimeUnit) {
        this.endIntervalTimeUnit = endIntervalTimeUnit;
    }

    public void setFetchMode(String fetchMode) {
        this.fetchMode = fetchMode;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setLatestTsKeyNames(List<String> latestTsKeyNames) {
        this.latestTsKeyNames = latestTsKeyNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbGetTelemetryNodeConfiguration)) {
            return false;
        }
        TbGetTelemetryNodeConfiguration other = (TbGetTelemetryNodeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartInterval() != other.getStartInterval()) {
            return false;
        }
        if (this.getEndInterval() != other.getEndInterval()) {
            return false;
        }
        if (this.isUseMetadataIntervalPatterns() != other.isUseMetadataIntervalPatterns()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        String this$startIntervalPattern = this.getStartIntervalPattern();
        String other$startIntervalPattern = other.getStartIntervalPattern();
        if (this$startIntervalPattern == null ? other$startIntervalPattern != null : !this$startIntervalPattern.equals(other$startIntervalPattern)) {
            return false;
        }
        String this$endIntervalPattern = this.getEndIntervalPattern();
        String other$endIntervalPattern = other.getEndIntervalPattern();
        if (this$endIntervalPattern == null ? other$endIntervalPattern != null : !this$endIntervalPattern.equals(other$endIntervalPattern)) {
            return false;
        }
        String this$startIntervalTimeUnit = this.getStartIntervalTimeUnit();
        String other$startIntervalTimeUnit = other.getStartIntervalTimeUnit();
        if (this$startIntervalTimeUnit == null ? other$startIntervalTimeUnit != null : !this$startIntervalTimeUnit.equals(other$startIntervalTimeUnit)) {
            return false;
        }
        String this$endIntervalTimeUnit = this.getEndIntervalTimeUnit();
        String other$endIntervalTimeUnit = other.getEndIntervalTimeUnit();
        if (this$endIntervalTimeUnit == null ? other$endIntervalTimeUnit != null : !this$endIntervalTimeUnit.equals(other$endIntervalTimeUnit)) {
            return false;
        }
        String this$fetchMode = this.getFetchMode();
        String other$fetchMode = other.getFetchMode();
        if (this$fetchMode == null ? other$fetchMode != null : !this$fetchMode.equals(other$fetchMode)) {
            return false;
        }
        String this$orderBy = this.getOrderBy();
        String other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy)) {
            return false;
        }
        List<String> this$latestTsKeyNames = this.getLatestTsKeyNames();
        List<String> other$latestTsKeyNames = other.getLatestTsKeyNames();
        return !(this$latestTsKeyNames == null ? other$latestTsKeyNames != null : !((Object)this$latestTsKeyNames).equals(other$latestTsKeyNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbGetTelemetryNodeConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStartInterval();
        result = result * 59 + this.getEndInterval();
        result = result * 59 + (this.isUseMetadataIntervalPatterns() ? 79 : 97);
        result = result * 59 + this.getLimit();
        String $startIntervalPattern = this.getStartIntervalPattern();
        result = result * 59 + ($startIntervalPattern == null ? 43 : $startIntervalPattern.hashCode());
        String $endIntervalPattern = this.getEndIntervalPattern();
        result = result * 59 + ($endIntervalPattern == null ? 43 : $endIntervalPattern.hashCode());
        String $startIntervalTimeUnit = this.getStartIntervalTimeUnit();
        result = result * 59 + ($startIntervalTimeUnit == null ? 43 : $startIntervalTimeUnit.hashCode());
        String $endIntervalTimeUnit = this.getEndIntervalTimeUnit();
        result = result * 59 + ($endIntervalTimeUnit == null ? 43 : $endIntervalTimeUnit.hashCode());
        String $fetchMode = this.getFetchMode();
        result = result * 59 + ($fetchMode == null ? 43 : $fetchMode.hashCode());
        String $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : $orderBy.hashCode());
        List<String> $latestTsKeyNames = this.getLatestTsKeyNames();
        result = result * 59 + ($latestTsKeyNames == null ? 43 : ((Object)$latestTsKeyNames).hashCode());
        return result;
    }

    public String toString() {
        return "TbGetTelemetryNodeConfiguration(startInterval=" + this.getStartInterval() + ", endInterval=" + this.getEndInterval() + ", startIntervalPattern=" + this.getStartIntervalPattern() + ", endIntervalPattern=" + this.getEndIntervalPattern() + ", useMetadataIntervalPatterns=" + this.isUseMetadataIntervalPatterns() + ", startIntervalTimeUnit=" + this.getStartIntervalTimeUnit() + ", endIntervalTimeUnit=" + this.getEndIntervalTimeUnit() + ", fetchMode=" + this.getFetchMode() + ", orderBy=" + this.getOrderBy() + ", limit=" + this.getLimit() + ", latestTsKeyNames=" + this.getLatestTsKeyNames() + ")";
    }
}

