/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractGetEntityDetailsNode;
import org.thingsboard.rule.engine.metadata.TbGetCustomerDetailsNodeConfiguration;
import org.thingsboard.server.common.data.ContactBased;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ENRICHMENT, name="customer details", configClazz=TbGetCustomerDetailsNodeConfiguration.class, nodeDescription="Adds fields from Customer details to the message body or metadata", nodeDetails="If checkbox: <b>Add selected details to the message metadata</b> is selected, existing fields will be added to the message metadata instead of message data.<br><br><b>Note:</b> only Device, Asset, and Entity View type are allowed.<br><br>If the originator of the message is not assigned to Customer, or originator type is not supported - Message will be forwarded to <b>Failure</b> chain, otherwise, <b>Success</b> chain will be used.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeEntityDetailsConfig")
public class TbGetCustomerDetailsNode
extends TbAbstractGetEntityDetailsNode<TbGetCustomerDetailsNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbGetCustomerDetailsNode.class);
    private static final String CUSTOMER_PREFIX = "customer_";

    @Override
    protected TbGetCustomerDetailsNodeConfiguration loadGetEntityDetailsNodeConfiguration(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbGetCustomerDetailsNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetCustomerDetailsNodeConfiguration.class);
    }

    @Override
    protected ListenableFuture<TbMsg> getDetails(TbContext ctx, TbMsg msg) {
        return this.getTbMsgListenableFuture(ctx, msg, this.getDataAsJson(msg), CUSTOMER_PREFIX);
    }

    @Override
    protected ListenableFuture<ContactBased> getContactBasedListenableFuture(TbContext ctx, TbMsg msg) {
        return Futures.transformAsync(this.getCustomer(ctx, msg), customer -> {
            if (customer != null) {
                return Futures.immediateFuture((Object)customer);
            }
            return Futures.immediateFuture(null);
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<Customer> getCustomer(TbContext ctx, TbMsg msg) {
        switch (msg.getOriginator().getEntityType()) {
            case DEVICE: {
                return Futures.transformAsync((ListenableFuture)ctx.getDeviceService().findDeviceByIdAsync(ctx.getTenantId(), new DeviceId(msg.getOriginator().getId())), device -> {
                    if (device != null) {
                        if (!device.getCustomerId().isNullUid()) {
                            return ctx.getCustomerService().findCustomerByIdAsync(ctx.getTenantId(), device.getCustomerId());
                        }
                        throw new RuntimeException("Device with name '" + device.getName() + "' is not assigned to Customer.");
                    }
                    return Futures.immediateFuture(null);
                }, (Executor)MoreExecutors.directExecutor());
            }
            case ASSET: {
                return Futures.transformAsync((ListenableFuture)ctx.getAssetService().findAssetByIdAsync(ctx.getTenantId(), new AssetId(msg.getOriginator().getId())), asset -> {
                    if (asset != null) {
                        if (!asset.getCustomerId().isNullUid()) {
                            return ctx.getCustomerService().findCustomerByIdAsync(ctx.getTenantId(), asset.getCustomerId());
                        }
                        throw new RuntimeException("Asset with name '" + asset.getName() + "' is not assigned to Customer.");
                    }
                    return Futures.immediateFuture(null);
                }, (Executor)MoreExecutors.directExecutor());
            }
            case ENTITY_VIEW: {
                return Futures.transformAsync((ListenableFuture)ctx.getEntityViewService().findEntityViewByIdAsync(ctx.getTenantId(), new EntityViewId(msg.getOriginator().getId())), entityView -> {
                    if (entityView != null) {
                        if (!entityView.getCustomerId().isNullUid()) {
                            return ctx.getCustomerService().findCustomerByIdAsync(ctx.getTenantId(), entityView.getCustomerId());
                        }
                        throw new RuntimeException("EntityView with name '" + entityView.getName() + "' is not assigned to Customer.");
                    }
                    return Futures.immediateFuture(null);
                }, (Executor)MoreExecutors.directExecutor());
            }
            case USER: {
                return Futures.transformAsync((ListenableFuture)ctx.getUserService().findUserByIdAsync(ctx.getTenantId(), new UserId(msg.getOriginator().getId())), user -> {
                    if (user != null) {
                        if (!user.getCustomerId().isNullUid()) {
                            return ctx.getCustomerService().findCustomerByIdAsync(ctx.getTenantId(), user.getCustomerId());
                        }
                        throw new RuntimeException("User with name '" + user.getName() + "' is not assigned to Customer.");
                    }
                    return Futures.immediateFuture(null);
                }, (Executor)MoreExecutors.directExecutor());
            }
        }
        throw new RuntimeException("Entity with entityType '" + msg.getOriginator().getEntityType() + "' is not supported.");
    }
}

