/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.mail;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.mail.EmailPojo;
import org.thingsboard.rule.engine.mail.TbMsgToEmailNodeConfiguration;
import org.thingsboard.server.common.data.id.BlobEntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.TRANSFORMATION, name="to email", configClazz=TbMsgToEmailNodeConfiguration.class, nodeDescription="Transforms message to email message", nodeDetails="Transforms message to email message by populating email fields using values derived from message metadata. Set 'SEND_EMAIL' output message type.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeToEmailConfig", icon="email")
public class TbMsgToEmailNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgToEmailNode.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String ATTACHMENTS = "attachments";
    private static final String EMAIL_TIMEZONE = "emailTimezone";
    private static final Pattern dateVarPattern = Pattern.compile("%d\\{([^\\}]*)\\}");
    private TbMsgToEmailNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgToEmailNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgToEmailNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        try {
            EmailPojo email = this.convert(msg);
            TbMsg emailMsg = this.buildEmailMsg(ctx, msg, email);
            ctx.tellNext(emailMsg, TbRelationTypes.SUCCESS);
        }
        catch (Exception ex) {
            log.warn("Can not convert message to email " + ex.getMessage());
            ctx.tellFailure(msg, (Throwable)ex);
        }
    }

    private TbMsg buildEmailMsg(TbContext ctx, TbMsg msg, EmailPojo email) throws JsonProcessingException {
        String emailJson = MAPPER.writeValueAsString((Object)email);
        return ctx.transformMsg(msg, "SEND_EMAIL", msg.getOriginator(), msg.getMetaData().copy(), emailJson);
    }

    private EmailPojo convert(TbMsg msg) throws IOException {
        TimeZone tz = null;
        String emailTimezone = msg.getMetaData().getValue(EMAIL_TIMEZONE);
        if (!StringUtils.isEmpty((Object)emailTimezone)) {
            tz = TimeZone.getTimeZone(emailTimezone);
        }
        Date currentDate = new Date();
        EmailPojo.EmailPojoBuilder builder = EmailPojo.builder();
        builder.from(this.fromTemplate(this.config.getFromTemplate(), msg));
        builder.to(this.fromTemplate(this.config.getToTemplate(), msg));
        builder.cc(this.fromTemplate(this.config.getCcTemplate(), msg));
        builder.bcc(this.fromTemplate(this.config.getBccTemplate(), msg));
        builder.subject(this.fromTemplateWithDate(this.config.getSubjectTemplate(), msg, currentDate, tz));
        builder.body(this.fromTemplateWithDate(this.config.getBodyTemplate(), msg, currentDate, tz));
        ArrayList<BlobEntityId> attachments = new ArrayList<BlobEntityId>();
        String attachmentsStr = msg.getMetaData().getValue(ATTACHMENTS);
        if (!StringUtils.isEmpty((Object)attachmentsStr)) {
            String[] attachmentsStrArray;
            for (String attachmentStr : attachmentsStrArray = attachmentsStr.split(",")) {
                attachments.add(new BlobEntityId(UUID.fromString(attachmentStr)));
            }
        }
        builder.attachments(attachments);
        return builder.build();
    }

    private String fromTemplate(String template, TbMsg msg) {
        if (!StringUtils.isEmpty((Object)template)) {
            return TbNodeUtils.processPattern((String)template, (TbMsg)msg);
        }
        return null;
    }

    private String fromTemplateWithDate(String template, TbMsg msg, Date currentDate, TimeZone tz) {
        if (!StringUtils.isEmpty((Object)template)) {
            return this.processDatePatterns(TbNodeUtils.processPattern((String)template, (TbMsg)msg), currentDate, tz);
        }
        return null;
    }

    private String processDatePatterns(String datePattern, Date currentDate, TimeZone tz) {
        String result = datePattern;
        Matcher matcher = dateVarPattern.matcher(datePattern);
        while (matcher.find()) {
            String toReplace = matcher.group(0);
            SimpleDateFormat dateFormat = new SimpleDateFormat(matcher.group(1));
            if (tz != null) {
                dateFormat.setTimeZone(tz);
            }
            String replacement = dateFormat.format(currentDate);
            result = result.replace(toReplace, replacement);
        }
        return result;
    }

    public void destroy() {
    }
}

