/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.integration;

import com.google.common.util.concurrent.FutureCallback;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.integration.TbIntegrationDownlinkConfiguration;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="integration downlink", configClazz=TbIntegrationDownlinkConfiguration.class, nodeDescription="Pushes downlink message to selected integration", nodeDetails="Will push downlink message to the selected integration queue.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeIntegrationDownlinkConfig", icon="input")
public class TbIntegrationDownlinkNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbIntegrationDownlinkNode.class);
    private TbIntegrationDownlinkConfiguration config;
    private IntegrationId integrationId;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbIntegrationDownlinkConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbIntegrationDownlinkConfiguration.class);
        if (this.config.getIntegrationId() == null) {
            throw new TbNodeException("Integration id is not set in the rule node configuration!");
        }
        this.integrationId = new IntegrationId(this.config.getIntegrationId());
        Integration integration = ctx.getPeContext().getIntegrationService().findIntegrationById(ctx.getTenantId(), this.integrationId);
        if (integration == null) {
            throw new TbNodeException("Integration with ID [" + this.integrationId + "] not found!");
        }
        if (!integration.getTenantId().equals((Object)ctx.getTenantId())) {
            throw new TbNodeException("Integration with ID [" + this.integrationId + "] belongs to different tenant!");
        }
    }

    public void onMsg(final TbContext ctx, final TbMsg msg) {
        if (this.integrationId != null) {
            ctx.getPeContext().pushToIntegration(this.integrationId, msg, (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void tmp) {
                    ctx.tellNext(msg, TbRelationTypes.SUCCESS);
                }

                public void onFailure(Throwable t) {
                    ctx.tellFailure(msg, t);
                }
            });
        } else {
            ctx.tellNext(msg, TbRelationTypes.FAILURE);
        }
    }

    public void destroy() {
        this.integrationId = null;
    }
}

