/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.geo;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.geo.AbstractGeofencingNode;
import org.thingsboard.rule.engine.geo.EntityGeofencingState;
import org.thingsboard.rule.engine.geo.TbGpsGeofencingActionNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="gps geofencing events", configClazz=TbGpsGeofencingActionNodeConfiguration.class, relationTypes={"Success", "Entered", "Left", "Inside", "Outside"}, nodeDescription="Produces incoming messages using GPS based geofencing", nodeDetails="Extracts latitude and longitude parameters from incoming message and returns different events based on configuration parameters", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeGpsGeofencingConfig")
public class TbGpsGeofencingActionNode
extends AbstractGeofencingNode<TbGpsGeofencingActionNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbGpsGeofencingActionNode.class);
    private final Map<EntityId, EntityGeofencingState> entityStates = new HashMap<EntityId, EntityGeofencingState>();
    private final Gson gson = new Gson();
    private final JsonParser parser = new JsonParser();

    public void onMsg(TbContext ctx, TbMsg msg) throws TbNodeException {
        long stayTime;
        boolean matches = this.checkMatches(msg);
        long ts = System.currentTimeMillis();
        EntityGeofencingState entityState = this.entityStates.computeIfAbsent(msg.getOriginator(), key -> {
            try {
                Optional entry = (Optional)ctx.getAttributesService().find(ctx.getTenantId(), msg.getOriginator(), "SERVER_SCOPE", ctx.getServiceId()).get(1L, TimeUnit.MINUTES);
                if (entry.isPresent()) {
                    JsonObject element = this.parser.parse(((AttributeKvEntry)entry.get()).getValueAsString()).getAsJsonObject();
                    return new EntityGeofencingState(element.get("inside").getAsBoolean(), element.get("stateSwitchTime").getAsLong(), element.get("stayed").getAsBoolean());
                }
                return new EntityGeofencingState(false, 0L, false);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        });
        boolean told = false;
        if (entityState.getStateSwitchTime() == 0L || entityState.isInside() != matches) {
            this.switchState(ctx, msg.getOriginator(), entityState, matches, ts);
            ctx.tellNext(msg, matches ? "Entered" : "Left");
            told = true;
        } else if (!entityState.isStayed() && (stayTime = ts - entityState.getStateSwitchTime()) > (entityState.isInside() ? TimeUnit.valueOf(((TbGpsGeofencingActionNodeConfiguration)this.config).getMinInsideDurationTimeUnit()).toMillis(((TbGpsGeofencingActionNodeConfiguration)this.config).getMinInsideDuration()) : TimeUnit.valueOf(((TbGpsGeofencingActionNodeConfiguration)this.config).getMinOutsideDurationTimeUnit()).toMillis(((TbGpsGeofencingActionNodeConfiguration)this.config).getMinOutsideDuration()))) {
            this.setStaid(ctx, msg.getOriginator(), entityState);
            ctx.tellNext(msg, entityState.isInside() ? "Inside" : "Outside");
            told = true;
        }
        if (!told) {
            ctx.tellSuccess(msg);
        }
    }

    private void switchState(TbContext ctx, EntityId entityId, EntityGeofencingState entityState, boolean matches, long ts) {
        entityState.setInside(matches);
        entityState.setStateSwitchTime(ts);
        entityState.setStayed(false);
        this.persist(ctx, entityId, entityState);
    }

    private void setStaid(TbContext ctx, EntityId entityId, EntityGeofencingState entityState) {
        entityState.setStayed(true);
        this.persist(ctx, entityId, entityState);
    }

    private void persist(TbContext ctx, EntityId entityId, EntityGeofencingState entityState) {
        JsonObject object = new JsonObject();
        object.addProperty("inside", Boolean.valueOf(entityState.isInside()));
        object.addProperty("stateSwitchTime", (Number)entityState.getStateSwitchTime());
        object.addProperty("stayed", Boolean.valueOf(entityState.isStayed()));
        BaseAttributeKvEntry entry = new BaseAttributeKvEntry((KvEntry)new StringDataEntry(ctx.getServiceId(), this.gson.toJson((JsonElement)object)), System.currentTimeMillis());
        List<BaseAttributeKvEntry> attributeKvEntryList = Collections.singletonList(entry);
        ctx.getAttributesService().save(ctx.getTenantId(), entityId, "SERVER_SCOPE", attributeKvEntryList);
    }

    @Override
    protected Class<TbGpsGeofencingActionNodeConfiguration> getConfigClazz() {
        return TbGpsGeofencingActionNodeConfiguration.class;
    }
}

