/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.EmptyNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.session.SessionMsgType;

@RuleNode(type=ComponentType.FILTER, name="message type switch", configClazz=EmptyNodeConfiguration.class, relationTypes={"Post attributes", "Post telemetry", "RPC Request from Device", "RPC Request to Device", "Activity Event", "Inactivity Event", "Connect Event", "Disconnect Event", "Entity Created", "Entity Updated", "Entity Deleted", "Entity Assigned", "Entity Unassigned", "Attributes Updated", "Attributes Deleted", "Alarm Acknowledged", "Alarm Cleared", "Added to Group", "Removed from Group", "REST API request", "Generate Report", "Other", "Entity Assigned From Tenant", "Entity Assigned To Tenant", "Timeseries Updated", "Timeseries Deleted"}, nodeDescription="Route incoming messages by Message Type", nodeDetails="Sends messages with message types <b>\"Post attributes\", \"Post telemetry\", \"RPC Request\"</b> etc. via corresponding chain, otherwise <b>Other</b> chain is used.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbNodeEmptyConfig")
public class TbMsgTypeSwitchNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgTypeSwitchNode.class);
    EmptyNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (EmptyNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, EmptyNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        String relationType = msg.getType().equals(SessionMsgType.POST_ATTRIBUTES_REQUEST.name()) ? "Post attributes" : (msg.getType().equals(SessionMsgType.POST_TELEMETRY_REQUEST.name()) ? "Post telemetry" : (msg.getType().equals(SessionMsgType.TO_SERVER_RPC_REQUEST.name()) ? "RPC Request from Device" : (msg.getType().equals("ACTIVITY_EVENT") ? "Activity Event" : (msg.getType().equals("INACTIVITY_EVENT") ? "Inactivity Event" : (msg.getType().equals("CONNECT_EVENT") ? "Connect Event" : (msg.getType().equals("DISCONNECT_EVENT") ? "Disconnect Event" : (msg.getType().equals("ENTITY_CREATED") ? "Entity Created" : (msg.getType().equals("ENTITY_UPDATED") ? "Entity Updated" : (msg.getType().equals("ENTITY_DELETED") ? "Entity Deleted" : (msg.getType().equals("ENTITY_ASSIGNED") ? "Entity Assigned" : (msg.getType().equals("ENTITY_UNASSIGNED") ? "Entity Unassigned" : (msg.getType().equals("ATTRIBUTES_UPDATED") ? "Attributes Updated" : (msg.getType().equals("ATTRIBUTES_DELETED") ? "Attributes Deleted" : (msg.getType().equals("ALARM_ACK") ? "Alarm Acknowledged" : (msg.getType().equals("ALARM_CLEAR") ? "Alarm Cleared" : (msg.getType().equals("RPC_CALL_FROM_SERVER_TO_DEVICE") ? "RPC Request to Device" : (msg.getType().equals("ADDED_TO_ENTITY_GROUP") ? "Added to Group" : (msg.getType().equals("REMOVED_FROM_ENTITY_GROUP") ? "Removed from Group" : (msg.getType().equals("REST_API_REQUEST") ? "REST API request" : (msg.getType().equals("generateReport") ? "Generate Report" : (msg.getType().equals("ENTITY_ASSIGNED_FROM_TENANT") ? "Entity Assigned From Tenant" : (msg.getType().equals("ENTITY_ASSIGNED_TO_TENANT") ? "Entity Assigned To Tenant" : (msg.getType().equals("TIMESERIES_UPDATED") ? "Timeseries Updated" : (msg.getType().equals("TIMESERIES_DELETED") ? "Timeseries Deleted" : "Other"))))))))))))))))))))))));
        ctx.tellNext(msg, relationType);
    }

    public void destroy() {
    }
}

