/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.filter.TbJsFilterNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="script", relationTypes={"True", "False"}, configClazz=TbJsFilterNodeConfiguration.class, nodeDescription="Filter incoming messages using JS script", nodeDetails="Evaluate incoming Message with configured JS condition. If <b>True</b> - send Message via <b>True</b> chain, otherwise <b>False</b> chain is used.Message payload can be accessed via <code>msg</code> property. For example <code>msg.temperature < 10;</code><br/>Message metadata can be accessed via <code>metadata</code> property. For example <code>metadata.customerName === 'John';</code><br/>Message type can be accessed via <code>msgType</code> property.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbFilterNodeScriptConfig")
public class TbJsFilterNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbJsFilterNode.class);
    private TbJsFilterNodeConfiguration config;
    private ScriptEngine jsEngine;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbJsFilterNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbJsFilterNodeConfiguration.class);
        this.jsEngine = ctx.createJsScriptEngine(this.config.getJsScript(), new String[0]);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        ctx.logJsEvalRequest();
        DonAsynchron.withCallback((ListenableFuture)this.jsEngine.executeFilterAsync(msg), filterResult -> {
            ctx.logJsEvalResponse();
            ctx.tellNext(msg, filterResult != false ? "True" : "False");
        }, t -> {
            ctx.tellFailure(msg, t);
            ctx.logJsEvalFailure();
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    public void destroy() {
        if (this.jsEngine != null) {
            this.jsEngine.destroy();
        }
    }
}

