/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.filter.TbCheckMessageNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="check existence fields", relationTypes={"True", "False"}, configClazz=TbCheckMessageNodeConfiguration.class, nodeDescription="Checks the existence of the selected keys from message data and metadata.", nodeDetails="If selected checkbox 'Check that all selected keys are present'\" and all keys in message data and metadata are exist - send Message via <b>True</b> chain, otherwise <b>False</b> chain is used.\nElse if the checkbox is not selected, and at least one of the keys from data or metadata of the message exists - send Message via <b>True</b> chain, otherwise, <b>False</b> chain is used. ", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbFilterNodeCheckMessageConfig")
public class TbCheckMessageNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbCheckMessageNode.class);
    private static final Gson gson = new Gson();
    private TbCheckMessageNodeConfiguration config;
    private List<String> messageNamesList;
    private List<String> metadataNamesList;

    public void init(TbContext tbContext, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbCheckMessageNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbCheckMessageNodeConfiguration.class);
        this.messageNamesList = this.config.getMessageNames();
        this.metadataNamesList = this.config.getMetadataNames();
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        try {
            if (this.config.isCheckAllKeys()) {
                ctx.tellNext(msg, this.allKeysData(msg) && this.allKeysMetadata(msg) ? "True" : "False");
            } else {
                ctx.tellNext(msg, this.atLeastOneData(msg) || this.atLeastOneMetadata(msg) ? "True" : "False");
            }
        }
        catch (Exception e) {
            ctx.tellFailure(msg, (Throwable)e);
        }
    }

    public void destroy() {
    }

    private boolean allKeysData(TbMsg msg) {
        if (!this.messageNamesList.isEmpty()) {
            Map<String, String> dataMap = this.dataToMap(msg);
            return this.processAllKeys(this.messageNamesList, dataMap);
        }
        return true;
    }

    private boolean allKeysMetadata(TbMsg msg) {
        if (!this.metadataNamesList.isEmpty()) {
            Map<String, String> metadataMap = this.metadataToMap(msg);
            return this.processAllKeys(this.metadataNamesList, metadataMap);
        }
        return true;
    }

    private boolean atLeastOneData(TbMsg msg) {
        if (!this.messageNamesList.isEmpty()) {
            Map<String, String> dataMap = this.dataToMap(msg);
            return this.processAtLeastOne(this.messageNamesList, dataMap);
        }
        return false;
    }

    private boolean atLeastOneMetadata(TbMsg msg) {
        if (!this.metadataNamesList.isEmpty()) {
            Map<String, String> metadataMap = this.metadataToMap(msg);
            return this.processAtLeastOne(this.metadataNamesList, metadataMap);
        }
        return false;
    }

    private boolean processAllKeys(List<String> data, Map<String, String> map) {
        for (String field : data) {
            if (map.containsKey(field)) continue;
            return false;
        }
        return true;
    }

    private boolean processAtLeastOne(List<String> data, Map<String, String> map) {
        for (String field : data) {
            if (!map.containsKey(field)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> metadataToMap(TbMsg msg) {
        return msg.getMetaData().getData();
    }

    private Map<String, String> dataToMap(TbMsg msg) {
        return (Map)gson.fromJson(msg.getData(), Map.class);
    }
}

