/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.delay;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.delay.TbMsgDelayNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.ACTION, name="delay", configClazz=TbMsgDelayNodeConfiguration.class, nodeDescription="Delays incoming message", nodeDetails="Delays messages for configurable period. Please note, this node acknowledges the message from the current queue (message will be removed from queue)", icon="pause", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeMsgDelayConfig")
public class TbMsgDelayNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgDelayNode.class);
    private static final String TB_MSG_DELAY_NODE_MSG = "TbMsgDelayNodeMsg";
    private TbMsgDelayNodeConfiguration config;
    private Map<UUID, TbMsg> pendingMsgs;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgDelayNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgDelayNodeConfiguration.class);
        this.pendingMsgs = new HashMap<UUID, TbMsg>();
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        if (msg.getType().equals(TB_MSG_DELAY_NODE_MSG)) {
            TbMsg pendingMsg = this.pendingMsgs.remove(UUID.fromString(msg.getData()));
            if (pendingMsg != null) {
                ctx.enqueueForTellNext(pendingMsg, TbRelationTypes.SUCCESS);
            }
        } else if (this.pendingMsgs.size() < this.config.getMaxPendingMsgs()) {
            this.pendingMsgs.put(msg.getId(), msg);
            TbMsg tickMsg = ctx.newMsg("Main", TB_MSG_DELAY_NODE_MSG, (EntityId)ctx.getSelfId(), new TbMsgMetaData(), msg.getId().toString());
            ctx.tellSelf(tickMsg, this.getDelay(msg));
            ctx.ack(msg);
        } else {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Max limit of pending messages reached!"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getDelay(TbMsg msg) {
        int periodInSeconds;
        if (this.config.isUseMetadataPeriodInSecondsPatterns()) {
            if (!this.isParsable(msg, this.config.getPeriodInSecondsPattern())) throw new RuntimeException("Can't parse period in seconds from metadata using pattern: " + this.config.getPeriodInSecondsPattern());
            periodInSeconds = Integer.parseInt(TbNodeUtils.processPattern((String)this.config.getPeriodInSecondsPattern(), (TbMsg)msg));
            return TimeUnit.SECONDS.toMillis(periodInSeconds);
        } else {
            periodInSeconds = this.config.getPeriodInSeconds();
        }
        return TimeUnit.SECONDS.toMillis(periodInSeconds);
    }

    private boolean isParsable(TbMsg msg, String pattern) {
        return NumberUtils.isParsable((String)TbNodeUtils.processPattern((String)pattern, (TbMsg)msg));
    }

    public void destroy() {
        this.pendingMsgs.clear();
    }
}

