/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.credentials;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.thingsboard.rule.engine.credentials.ClientCredentials;
import org.thingsboard.rule.engine.credentials.CredentialsType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CertPemCredentials
implements ClientCredentials {
    private static final Logger log = LoggerFactory.getLogger(CertPemCredentials.class);
    private static final String TLS_VERSION = "TLSv1.2";
    protected String caCert;
    private String cert;
    private String privateKey;
    private String password;
    static final String OPENSSL_ENCRYPTED_RSA_PRIVATEKEY_REGEX = "\\s*-----BEGIN RSA PRIVATE KEY-----\\s*Proc-Type: 4,ENCRYPTED\\s*DEK-Info:\\s*([^\\s]+)\\s+([\\s\\S]*)-----END RSA PRIVATE KEY-----\\s*";
    static final Pattern OPENSSL_ENCRYPTED_RSA_PRIVATEKEY_PATTERN = Pattern.compile("\\s*-----BEGIN RSA PRIVATE KEY-----\\s*Proc-Type: 4,ENCRYPTED\\s*DEK-Info:\\s*([^\\s]+)\\s+([\\s\\S]*)-----END RSA PRIVATE KEY-----\\s*");

    @Override
    public CredentialsType getType() {
        return CredentialsType.CERT_PEM;
    }

    @Override
    public SslContext initSslContext() {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            SslContextBuilder builder = SslContextBuilder.forClient();
            if (StringUtils.hasLength((String)this.caCert)) {
                builder.trustManager(this.createAndInitTrustManagerFactory());
            }
            if (StringUtils.hasLength((String)this.cert) && StringUtils.hasLength((String)this.privateKey)) {
                builder.keyManager(this.createAndInitKeyManagerFactory());
            }
            return builder.build();
        }
        catch (Exception e) {
            log.error("[{}:{}] Creating TLS factory failed!", new Object[]{this.caCert, this.cert, e});
            throw new RuntimeException("Creating TLS factory failed!", e);
        }
    }

    private KeyManagerFactory createAndInitKeyManagerFactory() throws Exception {
        PrivateKey privateKey;
        X509Certificate certHolder = this.readCertFile(this.cert);
        PrivateKey keyObject = this.readPrivateKeyFile(this.privateKey);
        char[] passwordCharArray = "".toCharArray();
        if (!StringUtils.isEmpty((Object)this.password)) {
            passwordCharArray = this.password.toCharArray();
        }
        JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider("BC");
        if (keyObject instanceof PEMEncryptedKeyPair) {
            PEMDecryptorProvider provider = new JcePEMDecryptorProviderBuilder().build(passwordCharArray);
            KeyPair key = keyConverter.getKeyPair(((PEMEncryptedKeyPair)keyObject).decryptKeyPair(provider));
            privateKey = key.getPrivate();
        } else if (keyObject instanceof PEMKeyPair) {
            KeyPair key = keyConverter.getKeyPair((PEMKeyPair)keyObject);
            privateKey = key.getPrivate();
        } else if (keyObject instanceof PrivateKey) {
            privateKey = keyObject;
        } else {
            throw new RuntimeException("Unable to get private key from object: " + keyObject.getClass());
        }
        KeyStore clientKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        clientKeyStore.load(null, null);
        clientKeyStore.setCertificateEntry("cert", certHolder);
        clientKeyStore.setKeyEntry("private-key", privateKey, passwordCharArray, new Certificate[]{certHolder});
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(clientKeyStore, passwordCharArray);
        return keyManagerFactory;
    }

    protected TrustManagerFactory createAndInitTrustManagerFactory() throws Exception {
        X509Certificate caCertHolder = this.readCertFile(this.caCert);
        KeyStore caKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        caKeyStore.load(null, null);
        caKeyStore.setCertificateEntry("caCert-cert", caCertHolder);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(caKeyStore);
        return trustManagerFactory;
    }

    private X509Certificate readCertFile(String fileContent) throws Exception {
        X509Certificate certificate = null;
        if (fileContent != null && !fileContent.trim().isEmpty()) {
            fileContent = fileContent.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replaceAll("\\s", "");
            byte[] decoded = org.apache.commons.codec.binary.Base64.decodeBase64((String)fileContent);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            try (ByteArrayInputStream inStream = new ByteArrayInputStream(decoded);){
                certificate = (X509Certificate)certFactory.generateCertificate(inStream);
            }
        }
        return certificate;
    }

    private PrivateKey readPrivateKeyFile(String fileContent) throws Exception {
        PrivateKey privateKey = null;
        if (fileContent != null && !fileContent.isEmpty()) {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            KeySpec keySpec = this.getKeySpec(fileContent);
            privateKey = keyFactory.generatePrivate(keySpec);
        }
        return privateKey;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeySpec getKeySpec(String encodedKey) throws Exception {
        void var2_6;
        Object var2_2 = null;
        Matcher matcher = OPENSSL_ENCRYPTED_RSA_PRIVATEKEY_PATTERN.matcher(encodedKey);
        if (matcher.matches()) {
            String encryptionDetails = matcher.group(1).trim();
            String encryptedKey = matcher.group(2).replaceAll("\\s", "");
            byte[] encryptedBinaryKey = Base64.getDecoder().decode(encryptedKey);
            String[] encryptionDetailsParts = encryptionDetails.split(",");
            if (encryptionDetailsParts.length != 2) throw new RuntimeException("Wrong encryption details!");
            String encryptionAlgorithm = encryptionDetailsParts[0];
            String encryptedAlgorithmParams = encryptionDetailsParts[1];
            byte[] pw = this.password.getBytes();
            byte[] iv = Hex.decode((String)encryptedAlgorithmParams);
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(pw);
            digest.update(iv, 0, 8);
            byte[] round1Digest = digest.digest();
            digest.update(round1Digest);
            digest.update(pw);
            digest.update(iv, 0, 8);
            byte[] round2Digest = digest.digest();
            Cipher cipher = null;
            SecretKeySpec secretKey = null;
            byte[] key = null;
            switch (encryptionAlgorithm) {
                case "AES-256-CBC": {
                    cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    key = new byte[32];
                    System.arraycopy(round1Digest, 0, key, 0, 16);
                    System.arraycopy(round2Digest, 0, key, 16, 16);
                    secretKey = new SecretKeySpec(key, "AES");
                    break;
                }
                case "AES-192-CBC": {
                    cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    key = new byte[24];
                    System.arraycopy(round1Digest, 0, key, 0, 16);
                    System.arraycopy(round2Digest, 0, key, 16, 8);
                    secretKey = new SecretKeySpec(key, "AES");
                    break;
                }
                case "AES-128-CBC": {
                    cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    key = new byte[16];
                    System.arraycopy(round1Digest, 0, key, 0, 16);
                    secretKey = new SecretKeySpec(key, "AES");
                    break;
                }
                case "DES-EDE3-CBC": {
                    cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                    key = new byte[24];
                    System.arraycopy(round1Digest, 0, key, 0, 16);
                    System.arraycopy(round2Digest, 0, key, 16, 8);
                    secretKey = new SecretKeySpec(key, "DESede");
                    break;
                }
                case "DES-CBC": {
                    cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
                    key = new byte[8];
                    System.arraycopy(round1Digest, 0, key, 0, 8);
                    secretKey = new SecretKeySpec(key, "DES");
                }
            }
            if (cipher == null) throw new RuntimeException("Unknown Encryption algorithm!");
            cipher.init(2, secretKey, new IvParameterSpec(iv));
            byte[] pkcs1 = cipher.doFinal(encryptedBinaryKey);
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = CertPemCredentials.decodeRSAPrivatePKCS1(pkcs1);
            return var2_6;
        } else {
            encodedKey = encodedKey.replaceAll(".*BEGIN.*PRIVATE KEY.*", "").replaceAll(".*END.*PRIVATE KEY.*", "").replaceAll("\\s", "");
            byte[] decoded = org.apache.commons.codec.binary.Base64.decodeBase64((String)encodedKey);
            if (this.password == null || this.password.isEmpty()) {
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(decoded);
                return var2_6;
            } else {
                PBEKeySpec pbeKeySpec = new PBEKeySpec(this.password.toCharArray());
                EncryptedPrivateKeyInfo privateKeyInfo = new EncryptedPrivateKeyInfo(decoded);
                String algorithmName = privateKeyInfo.getAlgName();
                Cipher cipher = Cipher.getInstance(algorithmName);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithmName);
                SecretKey pbeKey = secretKeyFactory.generateSecret(pbeKeySpec);
                AlgorithmParameters algParams = privateKeyInfo.getAlgParameters();
                cipher.init(2, (Key)pbeKey, algParams);
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = privateKeyInfo.getKeySpec(cipher);
            }
        }
        return var2_6;
    }

    private static BigInteger derint(ByteBuffer input) {
        int len = CertPemCredentials.der(input, 2);
        byte[] value = new byte[len];
        input.get(value);
        return new BigInteger(1, value);
    }

    private static int der(ByteBuffer input, int exp) {
        int tag = input.get() & 0xFF;
        if (tag != exp) {
            throw new IllegalArgumentException("Unexpected tag");
        }
        int n = input.get() & 0xFF;
        if (n < 128) {
            return n;
        }
        if ((n &= 0x7F) < 1 || n > 2) {
            throw new IllegalArgumentException("Invalid length");
        }
        int len = 0;
        while (n-- > 0) {
            len <<= 8;
            len |= input.get() & 0xFF;
        }
        return len;
    }

    static RSAPrivateCrtKeySpec decodeRSAPrivatePKCS1(byte[] encoded) {
        ByteBuffer input = ByteBuffer.wrap(encoded);
        if (CertPemCredentials.der(input, 48) != input.remaining()) {
            throw new IllegalArgumentException("Excess data");
        }
        if (!BigInteger.ZERO.equals(CertPemCredentials.derint(input))) {
            throw new IllegalArgumentException("Unsupported version");
        }
        BigInteger n = CertPemCredentials.derint(input);
        BigInteger e = CertPemCredentials.derint(input);
        BigInteger d = CertPemCredentials.derint(input);
        BigInteger p = CertPemCredentials.derint(input);
        BigInteger q = CertPemCredentials.derint(input);
        BigInteger ep = CertPemCredentials.derint(input);
        BigInteger eq = CertPemCredentials.derint(input);
        BigInteger c = CertPemCredentials.derint(input);
        return new RSAPrivateCrtKeySpec(n, e, d, p, q, ep, eq, c);
    }

    public String getCaCert() {
        return this.caCert;
    }

    public String getCert() {
        return this.cert;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPassword() {
        return this.password;
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CertPemCredentials)) {
            return false;
        }
        CertPemCredentials other = (CertPemCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$caCert = this.getCaCert();
        String other$caCert = other.getCaCert();
        if (this$caCert == null ? other$caCert != null : !this$caCert.equals(other$caCert)) {
            return false;
        }
        String this$cert = this.getCert();
        String other$cert = other.getCert();
        if (this$cert == null ? other$cert != null : !this$cert.equals(other$cert)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CertPemCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $caCert = this.getCaCert();
        result = result * 59 + ($caCert == null ? 43 : $caCert.hashCode());
        String $cert = this.getCert();
        result = result * 59 + ($cert == null ? 43 : $cert.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "CertPemCredentials(caCert=" + this.getCaCert() + ", cert=" + this.getCert() + ", privateKey=" + this.getPrivateKey() + ", password=" + this.getPassword() + ")";
    }
}

