/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.latest.telemetry;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import org.thingsboard.rule.engine.analytics.latest.telemetry.TbAggFunction;
import org.thingsboard.server.common.data.kv.KvEntry;

public abstract class TbBaseAggFunction
implements TbAggFunction {
    private boolean hasResult = false;

    @Override
    public void update(Optional<KvEntry> entry, double defaultValue) {
        double value = this.extractDoubleValue(entry, defaultValue);
        this.doUpdate(value);
        this.hasResult = true;
    }

    @Override
    public Optional<JsonElement> result() {
        if (this.hasResult) {
            return Optional.of(new JsonPrimitive((Number)this.prepareResult()));
        }
        return Optional.empty();
    }

    protected abstract void doUpdate(double var1);

    protected abstract double prepareResult();

    private double extractDoubleValue(Optional<KvEntry> entry, double defaultValue) {
        double result = defaultValue;
        if (entry.isPresent()) {
            KvEntry kvEntry = entry.get();
            switch (kvEntry.getDataType()) {
                case LONG: {
                    result = ((Long)kvEntry.getLongValue().get()).longValue();
                    break;
                }
                case DOUBLE: {
                    result = (Double)kvEntry.getDoubleValue().get();
                    break;
                }
                case BOOLEAN: {
                    result = (Boolean)kvEntry.getBooleanValue().get() != false ? 1.0 : 0.0;
                    break;
                }
                case STRING: {
                    String str = (String)kvEntry.getStrValue().get();
                    try {
                        result = Double.parseDouble(str);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Aggregation failed. Unable to parse value [" + str + "] of attribute [" + kvEntry.getKey() + "] to Double");
                    }
                }
            }
        }
        return result;
    }
}

