/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.latest.telemetry;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.analytics.latest.TbAbstractLatestNode;
import org.thingsboard.rule.engine.analytics.latest.telemetry.TbAggLatestTelemetryNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;

@RuleNode(type=ComponentType.ANALYTICS, name="aggregate latest", configClazz=TbAggLatestTelemetryNodeConfiguration.class, nodeDescription="Periodically aggregates entities attributes or latest timeseries", nodeDetails="Performs aggregation of attributes or latest timeseries fetched from child entities with configurable period. Generates 'POST_TELEMETRY_REQUEST' messages with aggregated values for each parent entity.", inEnabled=false, uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbAnalyticsNodeAggregateLatestConfig", icon="functions")
public class TbAggLatestTelemetryNode
extends TbAbstractLatestNode<TbAggLatestTelemetryNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbAggLatestTelemetryNode.class);
    private static final String TB_AGG_LATEST_NODE_MSG = "TbAggLatestNodeMsg";
    private Map<String, ScriptEngine> attributesScriptEngineMap = new ConcurrentHashMap<String, ScriptEngine>();

    @Override
    protected TbAggLatestTelemetryNodeConfiguration loadMapperNodeConfig(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbAggLatestTelemetryNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbAggLatestTelemetryNodeConfiguration.class);
    }

    @Override
    protected String tickMessageType() {
        return TB_AGG_LATEST_NODE_MSG;
    }

    @Override
    protected Map<EntityId, List<ListenableFuture<Optional<JsonObject>>>> doParentAggregations(TbContext ctx, EntityId parentEntityId) {
        ListenableFuture<List<EntityId>> childEntityIds = ((TbAggLatestTelemetryNodeConfiguration)this.config).getParentEntitiesQuery().getChildEntitiesAsync(ctx, parentEntityId);
        ArrayList aggregateFutures = new ArrayList();
        ((TbAggLatestTelemetryNodeConfiguration)this.config).getAggMappings().forEach(aggMapping -> aggregateFutures.add(aggMapping.aggregate(ctx, this.attributesScriptEngineMap, childEntityIds)));
        HashMap<EntityId, List<ListenableFuture<Optional<JsonObject>>>> result = new HashMap<EntityId, List<ListenableFuture<Optional<JsonObject>>>>();
        result.put(parentEntityId, aggregateFutures);
        return result;
    }

    public void destroy() {
        if (this.attributesScriptEngineMap != null) {
            for (ScriptEngine se : this.attributesScriptEngineMap.values()) {
                se.destroy();
            }
            this.attributesScriptEngineMap.clear();
        }
    }
}

