/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.latest.telemetry;

import org.thingsboard.rule.engine.analytics.incoming.MathFunction;
import org.thingsboard.rule.engine.analytics.latest.telemetry.TbAggFunction;
import org.thingsboard.rule.engine.analytics.latest.telemetry.TbAvgAggFunction;
import org.thingsboard.rule.engine.analytics.latest.telemetry.TbCountAggFunction;
import org.thingsboard.rule.engine.analytics.latest.telemetry.TbCountUniqueAggFunction;
import org.thingsboard.rule.engine.analytics.latest.telemetry.TbMaxAggFunction;
import org.thingsboard.rule.engine.analytics.latest.telemetry.TbMinAggFunction;
import org.thingsboard.rule.engine.analytics.latest.telemetry.TbSumAggFunction;

public class TbAggFunctionFactory {
    public static TbAggFunction createAggFunction(MathFunction mathFunction) {
        switch (mathFunction) {
            case MIN: {
                return new TbMinAggFunction();
            }
            case MAX: {
                return new TbMaxAggFunction();
            }
            case SUM: {
                return new TbSumAggFunction();
            }
            case AVG: {
                return new TbAvgAggFunction();
            }
            case COUNT: {
                return new TbCountAggFunction();
            }
            case COUNT_UNIQUE: {
                return new TbCountUniqueAggFunction();
            }
        }
        throw new IllegalArgumentException("Unsupported incoming function: " + mathFunction.name() + "!");
    }
}

