/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.latest.telemetry;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.server.common.data.id.EntityId;

public class AggLatestMappingFilter {
    private List<String> clientAttributeNames;
    private List<String> sharedAttributeNames;
    private List<String> serverAttributeNames;
    private List<String> latestTsKeyNames;
    private String filterFunction;
    @JsonIgnore
    private Predicate<EntityId> filter;

    public Predicate<EntityId> getFilterFunction(TbContext ctx, Map<String, ScriptEngine> attributesScriptEngineMap) {
        if (this.filter == null) {
            this.filter = entityId -> {
                try {
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    this.prepareAttributes(ctx, (Map<String, String>)attributes, (EntityId)entityId, "CLIENT_SCOPE", this.clientAttributeNames, "cs_");
                    this.prepareAttributes(ctx, (Map<String, String>)attributes, (EntityId)entityId, "SHARED_SCOPE", this.sharedAttributeNames, "shared_");
                    this.prepareAttributes(ctx, (Map<String, String>)attributes, (EntityId)entityId, "SERVER_SCOPE", this.serverAttributeNames, "ss_");
                    this.prepareTimeseries(ctx, (Map<String, String>)attributes, (EntityId)entityId, this.latestTsKeyNames);
                    ScriptEngine attributesScriptEngine = attributesScriptEngineMap.computeIfAbsent(this.filterFunction, function -> ctx.getPeContext().createAttributesJsScriptEngine(function));
                    return attributesScriptEngine.executeAttributesFilter(attributes);
                }
                catch (Exception e) {
                    throw new RuntimeException("[" + entityId + "] Failed to execute attributes mapping filter!", e);
                }
            };
        }
        return this.filter;
    }

    private void prepareAttributes(TbContext ctx, Map<String, String> attributes, EntityId entityId, String scope, List<String> keys, String prefix) throws Exception {
        if (keys != null && !keys.isEmpty()) {
            ListenableFuture latest = ctx.getAttributesService().find(ctx.getTenantId(), entityId, scope, keys);
            ((List)latest.get()).forEach(r -> {
                if (r.getValue() != null) {
                    attributes.put(prefix + r.getKey(), r.getValueAsString());
                }
            });
        }
    }

    private void prepareTimeseries(TbContext ctx, Map<String, String> attributes, EntityId entityId, List<String> keys) throws Exception {
        if (keys != null && !keys.isEmpty()) {
            ListenableFuture latest = ctx.getTimeseriesService().findLatest(ctx.getTenantId(), entityId, keys);
            ((List)latest.get()).forEach(r -> {
                if (r.getValue() != null) {
                    attributes.put(r.getKey(), r.getValueAsString());
                }
            });
        }
    }

    public List<String> getClientAttributeNames() {
        return this.clientAttributeNames;
    }

    public List<String> getSharedAttributeNames() {
        return this.sharedAttributeNames;
    }

    public List<String> getServerAttributeNames() {
        return this.serverAttributeNames;
    }

    public List<String> getLatestTsKeyNames() {
        return this.latestTsKeyNames;
    }

    public String getFilterFunction() {
        return this.filterFunction;
    }

    public Predicate<EntityId> getFilter() {
        return this.filter;
    }

    public void setClientAttributeNames(List<String> clientAttributeNames) {
        this.clientAttributeNames = clientAttributeNames;
    }

    public void setSharedAttributeNames(List<String> sharedAttributeNames) {
        this.sharedAttributeNames = sharedAttributeNames;
    }

    public void setServerAttributeNames(List<String> serverAttributeNames) {
        this.serverAttributeNames = serverAttributeNames;
    }

    public void setLatestTsKeyNames(List<String> latestTsKeyNames) {
        this.latestTsKeyNames = latestTsKeyNames;
    }

    public void setFilterFunction(String filterFunction) {
        this.filterFunction = filterFunction;
    }

    @JsonIgnore
    public void setFilter(Predicate<EntityId> filter) {
        this.filter = filter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggLatestMappingFilter)) {
            return false;
        }
        AggLatestMappingFilter other = (AggLatestMappingFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$clientAttributeNames = this.getClientAttributeNames();
        List<String> other$clientAttributeNames = other.getClientAttributeNames();
        if (this$clientAttributeNames == null ? other$clientAttributeNames != null : !((Object)this$clientAttributeNames).equals(other$clientAttributeNames)) {
            return false;
        }
        List<String> this$sharedAttributeNames = this.getSharedAttributeNames();
        List<String> other$sharedAttributeNames = other.getSharedAttributeNames();
        if (this$sharedAttributeNames == null ? other$sharedAttributeNames != null : !((Object)this$sharedAttributeNames).equals(other$sharedAttributeNames)) {
            return false;
        }
        List<String> this$serverAttributeNames = this.getServerAttributeNames();
        List<String> other$serverAttributeNames = other.getServerAttributeNames();
        if (this$serverAttributeNames == null ? other$serverAttributeNames != null : !((Object)this$serverAttributeNames).equals(other$serverAttributeNames)) {
            return false;
        }
        List<String> this$latestTsKeyNames = this.getLatestTsKeyNames();
        List<String> other$latestTsKeyNames = other.getLatestTsKeyNames();
        if (this$latestTsKeyNames == null ? other$latestTsKeyNames != null : !((Object)this$latestTsKeyNames).equals(other$latestTsKeyNames)) {
            return false;
        }
        String this$filterFunction = this.getFilterFunction();
        String other$filterFunction = other.getFilterFunction();
        if (this$filterFunction == null ? other$filterFunction != null : !this$filterFunction.equals(other$filterFunction)) {
            return false;
        }
        Predicate<EntityId> this$filter = this.getFilter();
        Predicate<EntityId> other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !this$filter.equals(other$filter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggLatestMappingFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $clientAttributeNames = this.getClientAttributeNames();
        result = result * 59 + ($clientAttributeNames == null ? 43 : ((Object)$clientAttributeNames).hashCode());
        List<String> $sharedAttributeNames = this.getSharedAttributeNames();
        result = result * 59 + ($sharedAttributeNames == null ? 43 : ((Object)$sharedAttributeNames).hashCode());
        List<String> $serverAttributeNames = this.getServerAttributeNames();
        result = result * 59 + ($serverAttributeNames == null ? 43 : ((Object)$serverAttributeNames).hashCode());
        List<String> $latestTsKeyNames = this.getLatestTsKeyNames();
        result = result * 59 + ($latestTsKeyNames == null ? 43 : ((Object)$latestTsKeyNames).hashCode());
        String $filterFunction = this.getFilterFunction();
        result = result * 59 + ($filterFunction == null ? 43 : $filterFunction.hashCode());
        Predicate<EntityId> $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        return result;
    }

    public String toString() {
        return "AggLatestMappingFilter(clientAttributeNames=" + this.getClientAttributeNames() + ", sharedAttributeNames=" + this.getSharedAttributeNames() + ", serverAttributeNames=" + this.getServerAttributeNames() + ", latestTsKeyNames=" + this.getLatestTsKeyNames() + ", filterFunction=" + this.getFilterFunction() + ", filter=" + this.getFilter() + ")";
    }
}

