/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.latest.telemetry;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.thingsboard.rule.engine.analytics.incoming.MathFunction;
import org.thingsboard.rule.engine.analytics.latest.telemetry.AggLatestMappingFilter;
import org.thingsboard.rule.engine.analytics.latest.telemetry.TbAggFunction;
import org.thingsboard.rule.engine.analytics.latest.telemetry.TbAggFunctionFactory;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;

public class AggLatestMapping {
    private String source;
    private String sourceScope;
    private double defaultValue;
    private String target;
    private MathFunction aggFunction;
    private AggLatestMappingFilter filter;

    public ListenableFuture<Optional<JsonObject>> aggregate(TbContext ctx, Map<String, ScriptEngine> attributesScriptEngineMap, ListenableFuture<List<EntityId>> entityIds) {
        ListenableFuture filteredEntityIds = this.filter != null ? Futures.transform(entityIds, ids -> {
            List filtered = ids.stream().filter(this.filter.getFilterFunction(ctx, attributesScriptEngineMap)).collect(Collectors.toList());
            return filtered;
        }, (Executor)ctx.getJsExecutor()) : entityIds;
        return Futures.transform((ListenableFuture)filteredEntityIds, ids -> {
            TbAggFunction aggregation = TbAggFunctionFactory.createAggFunction(this.aggFunction);
            ids.forEach(entityId -> {
                Optional<KvEntry> entry = aggregation.fetchAttrValue() ? this.fetchValue(ctx, (EntityId)entityId) : Optional.empty();
                aggregation.update(entry, this.defaultValue);
            });
            Optional<JsonElement> result = aggregation.result();
            if (result.isPresent()) {
                JsonObject obj = new JsonObject();
                obj.add(this.target, result.get());
                return Optional.of(obj);
            }
            return Optional.empty();
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private Optional<KvEntry> fetchValue(TbContext ctx, EntityId entityId) {
        try {
            if ("LATEST_TELEMETRY".equals(this.sourceScope)) {
                ListenableFuture latest = ctx.getTimeseriesService().findLatest(ctx.getTenantId(), entityId, Collections.singletonList(this.source));
                List latestTs = (List)latest.get();
                if (latestTs != null && !latestTs.isEmpty() && ((TsKvEntry)latestTs.get(0)).getValue() != null) {
                    return Optional.of((KvEntry)latestTs.get(0));
                }
            } else {
                ListenableFuture latest = ctx.getAttributesService().find(ctx.getTenantId(), entityId, this.sourceScope, this.source);
                Optional latestAttr = (Optional)latest.get();
                if (latestAttr.isPresent()) {
                    return Optional.of((KvEntry)latestAttr.get());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch value of attribute/telemetry telemetry [" + this.source + "] of entity [" + entityId + "]", e);
        }
        return Optional.empty();
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceScope() {
        return this.sourceScope;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public String getTarget() {
        return this.target;
    }

    public MathFunction getAggFunction() {
        return this.aggFunction;
    }

    public AggLatestMappingFilter getFilter() {
        return this.filter;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSourceScope(String sourceScope) {
        this.sourceScope = sourceScope;
    }

    public void setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setAggFunction(MathFunction aggFunction) {
        this.aggFunction = aggFunction;
    }

    public void setFilter(AggLatestMappingFilter filter) {
        this.filter = filter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggLatestMapping)) {
            return false;
        }
        AggLatestMapping other = (AggLatestMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getDefaultValue(), other.getDefaultValue()) != 0) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$sourceScope = this.getSourceScope();
        String other$sourceScope = other.getSourceScope();
        if (this$sourceScope == null ? other$sourceScope != null : !this$sourceScope.equals(other$sourceScope)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        MathFunction this$aggFunction = this.getAggFunction();
        MathFunction other$aggFunction = other.getAggFunction();
        if (this$aggFunction == null ? other$aggFunction != null : !((Object)((Object)this$aggFunction)).equals((Object)other$aggFunction)) {
            return false;
        }
        AggLatestMappingFilter this$filter = this.getFilter();
        AggLatestMappingFilter other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggLatestMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $defaultValue = Double.doubleToLongBits(this.getDefaultValue());
        result = result * 59 + (int)($defaultValue >>> 32 ^ $defaultValue);
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $sourceScope = this.getSourceScope();
        result = result * 59 + ($sourceScope == null ? 43 : $sourceScope.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        MathFunction $aggFunction = this.getAggFunction();
        result = result * 59 + ($aggFunction == null ? 43 : ((Object)((Object)$aggFunction)).hashCode());
        AggLatestMappingFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        return result;
    }

    public String toString() {
        return "AggLatestMapping(source=" + this.getSource() + ", sourceScope=" + this.getSourceScope() + ", defaultValue=" + this.getDefaultValue() + ", target=" + this.getTarget() + ", aggFunction=" + this.getAggFunction() + ", filter=" + this.getFilter() + ")";
    }
}

