/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.latest.alarm;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.analytics.latest.alarm.AlarmsCountMapping;
import org.thingsboard.rule.engine.analytics.latest.alarm.TbAlarmsCountNodeV2Configuration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmFilter;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmQuery;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.session.SessionMsgType;
import org.thingsboard.server.dao.util.mapping.JacksonUtil;

@RuleNode(type=ComponentType.ANALYTICS, name="alarms count", configClazz=TbAlarmsCountNodeV2Configuration.class, nodeDescription="Counts alarms by msg originator", nodeDetails="Performs count of alarms for originator and for propagation entities if specified. Generates 'POST_TELEMETRY_REQUEST' messages with alarm count values for each found entity.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbAnalyticsNodeAlarmsCountV2Config", icon="functions")
public class TbAlarmsCountNodeV2
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbAlarmsCountNodeV2.class);
    private TbAlarmsCountNodeV2Configuration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbAlarmsCountNodeV2Configuration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbAlarmsCountNodeV2Configuration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        String msgType = msg.getType();
        EntityType entityType = msg.getOriginator().getEntityType();
        if (msgType.equals("ENTITY_CREATED") && entityType.equals((Object)EntityType.ALARM) || msgType.equals("ENTITY_UPDATED") && entityType.equals((Object)EntityType.ALARM) || msgType.equals("ALARM") || msgType.equals("ALARM_ACK") || msgType.equals("ALARM_CLEAR")) {
            this.process(ctx, msg);
        } else {
            ctx.tellSuccess(msg);
        }
    }

    private void process(TbContext ctx, TbMsg msg) {
        Alarm alarm = (Alarm)JacksonUtil.fromString((String)msg.getData(), AlarmInfo.class);
        HashMap<EntityId, ObjectNode> result = new HashMap<EntityId, ObjectNode>();
        this.getPropagationEntityIds(ctx, alarm).forEach(entityId -> result.put((EntityId)entityId, this.countAlarms(ctx, (EntityId)entityId)));
        String dataTs = Long.toString(System.currentTimeMillis());
        result.forEach((entityId, data) -> {
            TbMsgMetaData metaData = new TbMsgMetaData();
            metaData.putValue("ts", dataTs);
            TbMsg newMsg = TbMsg.newMsg((String)SessionMsgType.POST_TELEMETRY_REQUEST.name(), (EntityId)entityId, (TbMsgMetaData)metaData, (String)JacksonUtil.toString((Object)data));
            ctx.enqueueForTellNext(newMsg, TbRelationTypes.SUCCESS);
        });
        ctx.ack(msg);
    }

    private Set<EntityId> getPropagationEntityIds(TbContext ctx, Alarm alarm) {
        if (this.config.isCountAlarmsForPropagationEntities() && alarm.isPropagate()) {
            List relations = ctx.getRelationService().findByTo(alarm.getTenantId(), (EntityId)alarm.getId(), RelationTypeGroup.ALARM);
            Set<EntityId> propagationEntityIds = relations.stream().map(EntityRelation::getFrom).collect(Collectors.toSet());
            propagationEntityIds.add(alarm.getOriginator());
            return propagationEntityIds;
        }
        return Collections.singleton(alarm.getOriginator());
    }

    private ObjectNode countAlarms(TbContext ctx, EntityId entityId) {
        List<AlarmsCountMapping> mappings = this.config.getAlarmsCountMappings();
        ArrayList<AlarmFilter> filters = new ArrayList<AlarmFilter>();
        for (AlarmsCountMapping mapping : mappings) {
            filters.add(mapping.createAlarmFilter());
        }
        long interval = 0L;
        for (AlarmsCountMapping mapping : mappings) {
            if (mapping.getLatestInterval() == 0L) {
                interval = 0L;
                break;
            }
            interval = Math.max(interval, mapping.getLatestInterval());
        }
        PageLink alarmSearchPageLink = new PageLink(Integer.MAX_VALUE);
        TimePageLink pageLink = interval > 0L ? new TimePageLink(alarmSearchPageLink, Long.valueOf(System.currentTimeMillis() - interval), null) : new TimePageLink(alarmSearchPageLink, null, null);
        AlarmQuery alarmQuery = new AlarmQuery(entityId, pageLink, null, null, Boolean.valueOf(false), null);
        List alarmCounts = ctx.getAlarmService().findAlarmCounts(ctx.getTenantId(), alarmQuery, filters);
        ObjectNode obj = JacksonUtil.newObjectNode();
        for (int i = 0; i < mappings.size(); ++i) {
            obj.put(mappings.get(i).getTarget(), (Long)alarmCounts.get(i));
        }
        return obj;
    }

    public void destroy() {
    }
}

