/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.latest.alarm;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.analytics.latest.TbAbstractLatestNode;
import org.thingsboard.rule.engine.analytics.latest.alarm.AlarmsCountMapping;
import org.thingsboard.rule.engine.analytics.latest.alarm.TbAlarmsCountNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.alarm.AlarmFilter;
import org.thingsboard.server.common.data.alarm.AlarmQuery;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.session.SessionMsgType;

@RuleNode(type=ComponentType.ANALYTICS, name="alarms count (deprecated)", configClazz=TbAlarmsCountNodeConfiguration.class, nodeDescription="Periodically counts alarms for entities", nodeDetails="Performs count of alarms for parent entities and child entities if specified with configurable period. Generates 'POST_TELEMETRY_REQUEST' messages with alarm count values for each found entity.", inEnabled=false, uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbAnalyticsNodeAlarmsCountConfig", icon="functions")
public class TbAlarmsCountNode
extends TbAbstractLatestNode<TbAlarmsCountNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbAlarmsCountNode.class);
    private static final String TB_ALARMS_COUNT_NODE_MSG = "TbAlarmsCountNodeMsg";

    @Override
    protected TbAlarmsCountNodeConfiguration loadMapperNodeConfig(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbAlarmsCountNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbAlarmsCountNodeConfiguration.class);
    }

    @Override
    protected String tickMessageType() {
        return TB_ALARMS_COUNT_NODE_MSG;
    }

    @Override
    protected Map<EntityId, List<ListenableFuture<Optional<JsonObject>>>> doParentAggregations(TbContext ctx, EntityId parentEntityId) {
        ArrayList<EntityId> entityIds = new ArrayList<EntityId>();
        entityIds.add(parentEntityId);
        if (((TbAlarmsCountNodeConfiguration)this.config).isCountAlarmsForChildEntities()) {
            ListenableFuture<List<EntityId>> childEntityIdsFuture = ((TbAlarmsCountNodeConfiguration)this.config).getParentEntitiesQuery().getChildEntitiesAsync(ctx, parentEntityId);
            try {
                entityIds.addAll((Collection)childEntityIdsFuture.get());
            }
            catch (Exception e) {
                TbMsg msg = TbMsg.newMsg((String)SessionMsgType.POST_TELEMETRY_REQUEST.name(), (EntityId)parentEntityId, (TbMsgMetaData)new TbMsgMetaData(), (String)"");
                ctx.enqueueForTellFailure(msg, "Failed to fetch child entities for parent entity [" + parentEntityId + "]");
            }
        }
        HashMap<EntityId, List<ListenableFuture<Optional<JsonObject>>>> result = new HashMap<EntityId, List<ListenableFuture<Optional<JsonObject>>>>();
        entityIds.forEach(entityId -> {
            ArrayList<ListenableFuture> aggregateFutures = new ArrayList<ListenableFuture>();
            JsonObject data = this.countAlarms(ctx, (EntityId)entityId);
            aggregateFutures.add(Futures.immediateFuture(Optional.of(data)));
            result.put((EntityId)entityId, (List<ListenableFuture<Optional<JsonObject>>>)aggregateFutures);
        });
        return result;
    }

    private JsonObject countAlarms(TbContext ctx, EntityId entityId) {
        List<AlarmsCountMapping> mappings = ((TbAlarmsCountNodeConfiguration)this.config).getAlarmsCountMappings();
        ArrayList<AlarmFilter> filters = new ArrayList<AlarmFilter>();
        for (AlarmsCountMapping mapping : mappings) {
            filters.add(mapping.createAlarmFilter());
        }
        long interval = 0L;
        for (AlarmsCountMapping mapping : mappings) {
            if (mapping.getLatestInterval() == 0L) {
                interval = 0L;
                break;
            }
            interval = Math.max(interval, mapping.getLatestInterval());
        }
        PageLink alarmSearchPageLink = new PageLink(Integer.MAX_VALUE);
        TimePageLink pageLink = interval > 0L ? new TimePageLink(alarmSearchPageLink, Long.valueOf(System.currentTimeMillis() - interval), null) : new TimePageLink(alarmSearchPageLink, null, null);
        AlarmQuery alarmQuery = new AlarmQuery(entityId, pageLink, null, null, Boolean.valueOf(false), null);
        List alarmCounts = ctx.getAlarmService().findAlarmCounts(ctx.getTenantId(), alarmQuery, filters);
        JsonObject obj = new JsonObject();
        for (int i = 0; i < mappings.size(); ++i) {
            obj.addProperty(mappings.get(i).getTarget(), (Number)alarmCounts.get(i));
        }
        return obj;
    }

    public void destroy() {
    }
}

