/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.latest.alarm;

import java.util.List;
import org.thingsboard.server.common.data.alarm.AlarmFilter;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;

public class AlarmsCountMapping {
    private String target;
    private List<String> typesList;
    private List<AlarmSeverity> severityList;
    private List<AlarmStatus> statusList;
    private long latestInterval;

    public AlarmFilter createAlarmFilter() {
        Long startTime = null;
        if (this.latestInterval > 0L) {
            startTime = System.currentTimeMillis() - this.latestInterval;
        }
        return new AlarmFilter(this.nullIfEmpty(this.typesList), this.nullIfEmpty(this.severityList), this.nullIfEmpty(this.statusList), startTime);
    }

    private <T> List<T> nullIfEmpty(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public String getTarget() {
        return this.target;
    }

    public List<String> getTypesList() {
        return this.typesList;
    }

    public List<AlarmSeverity> getSeverityList() {
        return this.severityList;
    }

    public List<AlarmStatus> getStatusList() {
        return this.statusList;
    }

    public long getLatestInterval() {
        return this.latestInterval;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTypesList(List<String> typesList) {
        this.typesList = typesList;
    }

    public void setSeverityList(List<AlarmSeverity> severityList) {
        this.severityList = severityList;
    }

    public void setStatusList(List<AlarmStatus> statusList) {
        this.statusList = statusList;
    }

    public void setLatestInterval(long latestInterval) {
        this.latestInterval = latestInterval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmsCountMapping)) {
            return false;
        }
        AlarmsCountMapping other = (AlarmsCountMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLatestInterval() != other.getLatestInterval()) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        List<String> this$typesList = this.getTypesList();
        List<String> other$typesList = other.getTypesList();
        if (this$typesList == null ? other$typesList != null : !((Object)this$typesList).equals(other$typesList)) {
            return false;
        }
        List<AlarmSeverity> this$severityList = this.getSeverityList();
        List<AlarmSeverity> other$severityList = other.getSeverityList();
        if (this$severityList == null ? other$severityList != null : !((Object)this$severityList).equals(other$severityList)) {
            return false;
        }
        List<AlarmStatus> this$statusList = this.getStatusList();
        List<AlarmStatus> other$statusList = other.getStatusList();
        return !(this$statusList == null ? other$statusList != null : !((Object)this$statusList).equals(other$statusList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmsCountMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $latestInterval = this.getLatestInterval();
        result = result * 59 + (int)($latestInterval >>> 32 ^ $latestInterval);
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        List<String> $typesList = this.getTypesList();
        result = result * 59 + ($typesList == null ? 43 : ((Object)$typesList).hashCode());
        List<AlarmSeverity> $severityList = this.getSeverityList();
        result = result * 59 + ($severityList == null ? 43 : ((Object)$severityList).hashCode());
        List<AlarmStatus> $statusList = this.getStatusList();
        result = result * 59 + ($statusList == null ? 43 : ((Object)$statusList).hashCode());
        return result;
    }

    public String toString() {
        return "AlarmsCountMapping(target=" + this.getTarget() + ", typesList=" + this.getTypesList() + ", severityList=" + this.getSeverityList() + ", statusList=" + this.getStatusList() + ", latestInterval=" + this.getLatestInterval() + ")";
    }
}

