/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.latest;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import org.thingsboard.rule.engine.analytics.latest.ParentEntitiesQuery;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.data.RelationsQuery;
import org.thingsboard.rule.engine.util.EntitiesRelatedEntityIdAsyncLoader;
import org.thingsboard.server.common.data.id.EntityId;

public class ParentEntitiesSingleEntity
implements ParentEntitiesQuery {
    private EntityId entityId;
    private RelationsQuery childRelationsQuery;

    @Override
    public ListenableFuture<List<EntityId>> getParentEntitiesAsync(TbContext ctx) {
        if (ctx.getPeContext().isLocalEntity(this.entityId)) {
            return Futures.immediateFuture(Collections.singletonList(this.entityId));
        }
        return Futures.immediateFuture(Collections.emptyList());
    }

    @Override
    public ListenableFuture<List<EntityId>> getChildEntitiesAsync(TbContext ctx, EntityId parentEntityId) {
        return EntitiesRelatedEntityIdAsyncLoader.findEntitiesAsync(ctx, parentEntityId, this.childRelationsQuery);
    }

    @Override
    public boolean useParentEntitiesOnlyForSimpleAggregation() {
        return true;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public RelationsQuery getChildRelationsQuery() {
        return this.childRelationsQuery;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    public void setChildRelationsQuery(RelationsQuery childRelationsQuery) {
        this.childRelationsQuery = childRelationsQuery;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParentEntitiesSingleEntity)) {
            return false;
        }
        ParentEntitiesSingleEntity other = (ParentEntitiesSingleEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        RelationsQuery this$childRelationsQuery = this.getChildRelationsQuery();
        RelationsQuery other$childRelationsQuery = other.getChildRelationsQuery();
        return !(this$childRelationsQuery == null ? other$childRelationsQuery != null : !((Object)this$childRelationsQuery).equals(other$childRelationsQuery));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParentEntitiesSingleEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        RelationsQuery $childRelationsQuery = this.getChildRelationsQuery();
        result = result * 59 + ($childRelationsQuery == null ? 43 : ((Object)$childRelationsQuery).hashCode());
        return result;
    }

    public String toString() {
        return "ParentEntitiesSingleEntity(entityId=" + this.getEntityId() + ", childRelationsQuery=" + this.getChildRelationsQuery() + ")";
    }
}

