/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.latest;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.thingsboard.rule.engine.analytics.latest.ParentEntitiesQuery;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.data.RelationsQuery;
import org.thingsboard.rule.engine.util.EntitiesRelatedEntityIdAsyncLoader;
import org.thingsboard.server.common.data.id.EntityId;

public class ParentEntitiesRelationsQuery
implements ParentEntitiesQuery {
    private EntityId rootEntityId;
    private RelationsQuery relationsQuery;
    private RelationsQuery childRelationsQuery;

    @Override
    public ListenableFuture<List<EntityId>> getParentEntitiesAsync(TbContext ctx) {
        return EntitiesRelatedEntityIdAsyncLoader.findEntitiesAsync(ctx, this.rootEntityId, this.relationsQuery, entityId -> ctx.getPeContext().isLocalEntity(entityId));
    }

    @Override
    public ListenableFuture<List<EntityId>> getChildEntitiesAsync(TbContext ctx, EntityId parentEntityId) {
        return EntitiesRelatedEntityIdAsyncLoader.findEntitiesAsync(ctx, parentEntityId, this.childRelationsQuery);
    }

    @Override
    public boolean useParentEntitiesOnlyForSimpleAggregation() {
        return true;
    }

    public EntityId getRootEntityId() {
        return this.rootEntityId;
    }

    public RelationsQuery getRelationsQuery() {
        return this.relationsQuery;
    }

    public RelationsQuery getChildRelationsQuery() {
        return this.childRelationsQuery;
    }

    public void setRootEntityId(EntityId rootEntityId) {
        this.rootEntityId = rootEntityId;
    }

    public void setRelationsQuery(RelationsQuery relationsQuery) {
        this.relationsQuery = relationsQuery;
    }

    public void setChildRelationsQuery(RelationsQuery childRelationsQuery) {
        this.childRelationsQuery = childRelationsQuery;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParentEntitiesRelationsQuery)) {
            return false;
        }
        ParentEntitiesRelationsQuery other = (ParentEntitiesRelationsQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$rootEntityId = this.getRootEntityId();
        EntityId other$rootEntityId = other.getRootEntityId();
        if (this$rootEntityId == null ? other$rootEntityId != null : !this$rootEntityId.equals(other$rootEntityId)) {
            return false;
        }
        RelationsQuery this$relationsQuery = this.getRelationsQuery();
        RelationsQuery other$relationsQuery = other.getRelationsQuery();
        if (this$relationsQuery == null ? other$relationsQuery != null : !((Object)this$relationsQuery).equals(other$relationsQuery)) {
            return false;
        }
        RelationsQuery this$childRelationsQuery = this.getChildRelationsQuery();
        RelationsQuery other$childRelationsQuery = other.getChildRelationsQuery();
        return !(this$childRelationsQuery == null ? other$childRelationsQuery != null : !((Object)this$childRelationsQuery).equals(other$childRelationsQuery));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParentEntitiesRelationsQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $rootEntityId = this.getRootEntityId();
        result = result * 59 + ($rootEntityId == null ? 43 : $rootEntityId.hashCode());
        RelationsQuery $relationsQuery = this.getRelationsQuery();
        result = result * 59 + ($relationsQuery == null ? 43 : ((Object)$relationsQuery).hashCode());
        RelationsQuery $childRelationsQuery = this.getChildRelationsQuery();
        result = result * 59 + ($childRelationsQuery == null ? 43 : ((Object)$childRelationsQuery).hashCode());
        return result;
    }

    public String toString() {
        return "ParentEntitiesRelationsQuery(rootEntityId=" + this.getRootEntityId() + ", relationsQuery=" + this.getRelationsQuery() + ", childRelationsQuery=" + this.getChildRelationsQuery() + ")";
    }
}

