/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.latest;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import org.thingsboard.rule.engine.analytics.latest.ParentEntitiesQuery;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageLink;

public class ParentEntitiesGroup
implements ParentEntitiesQuery {
    private EntityId entityGroupId;

    @Override
    public ListenableFuture<List<EntityId>> getParentEntitiesAsync(TbContext ctx) {
        if (ctx.getPeContext().isLocalEntity(this.entityGroupId)) {
            return Futures.immediateFuture(Collections.singletonList(this.entityGroupId));
        }
        return Futures.immediateFuture(Collections.emptyList());
    }

    @Override
    public ListenableFuture<List<EntityId>> getChildEntitiesAsync(TbContext ctx, EntityId parentEntityId) {
        return ctx.getPeContext().getEntityGroupService().findAllEntityIds(ctx.getTenantId(), new EntityGroupId(parentEntityId.getId()), new PageLink(Integer.MAX_VALUE));
    }

    @Override
    public boolean useParentEntitiesOnlyForSimpleAggregation() {
        return false;
    }

    public EntityId getEntityGroupId() {
        return this.entityGroupId;
    }

    public void setEntityGroupId(EntityId entityGroupId) {
        this.entityGroupId = entityGroupId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParentEntitiesGroup)) {
            return false;
        }
        ParentEntitiesGroup other = (ParentEntitiesGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$entityGroupId = this.getEntityGroupId();
        EntityId other$entityGroupId = other.getEntityGroupId();
        return !(this$entityGroupId == null ? other$entityGroupId != null : !this$entityGroupId.equals(other$entityGroupId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParentEntitiesGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $entityGroupId = this.getEntityGroupId();
        result = result * 59 + ($entityGroupId == null ? 43 : $entityGroupId.hashCode());
        return result;
    }

    public String toString() {
        return "ParentEntitiesGroup(entityGroupId=" + this.getEntityGroupId() + ")";
    }
}

