/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.incoming.state;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import org.thingsboard.rule.engine.analytics.incoming.state.TbBaseIntervalState;

public class TbSumIntervalState
extends TbBaseIntervalState {
    private BigDecimal sum = BigDecimal.ZERO;

    public TbSumIntervalState(JsonElement stateJson) {
        this.sum = new BigDecimal(stateJson.getAsJsonObject().get("sum").getAsString());
    }

    @Override
    protected boolean doUpdate(JsonElement data) {
        double value = data.getAsDouble();
        if (value != 0.0) {
            this.sum = this.sum.add(BigDecimal.valueOf(value));
            return true;
        }
        return false;
    }

    @Override
    public String toValueJson(Gson gson, String outputValueKey) {
        JsonObject json = new JsonObject();
        json.addProperty(outputValueKey, (Number)this.sum);
        return gson.toJson((JsonElement)json);
    }

    @Override
    public String toStateJson(Gson gson) {
        JsonObject object = new JsonObject();
        object.addProperty("sum", this.sum.toString());
        return gson.toJson((JsonElement)object);
    }

    public BigDecimal getSum() {
        return this.sum;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbSumIntervalState)) {
            return false;
        }
        TbSumIntervalState other = (TbSumIntervalState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$sum = this.getSum();
        BigDecimal other$sum = other.getSum();
        return !(this$sum == null ? other$sum != null : !((Object)this$sum).equals(other$sum));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TbSumIntervalState;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $sum = this.getSum();
        result = result * 59 + ($sum == null ? 43 : ((Object)$sum).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TbSumIntervalState(sum=" + this.getSum() + ")";
    }

    public TbSumIntervalState() {
    }
}

