/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.incoming.state;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.thingsboard.rule.engine.analytics.incoming.state.TbBaseIntervalState;

public class TbMinIntervalState
extends TbBaseIntervalState {
    private double min = Double.MAX_VALUE;

    public TbMinIntervalState(JsonElement stateJson) {
        this.min = stateJson.getAsJsonObject().get("min").getAsDouble();
    }

    @Override
    protected boolean doUpdate(JsonElement data) {
        double value = data.getAsDouble();
        if (value < this.min) {
            this.min = value;
            return true;
        }
        return false;
    }

    @Override
    public String toValueJson(Gson gson, String outputValueKey) {
        JsonObject json = new JsonObject();
        json.addProperty(outputValueKey, (Number)this.min);
        return gson.toJson((JsonElement)json);
    }

    @Override
    public String toStateJson(Gson gson) {
        JsonObject object = new JsonObject();
        object.addProperty("min", (Number)this.min);
        return gson.toJson((JsonElement)object);
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbMinIntervalState)) {
            return false;
        }
        TbMinIntervalState other = (TbMinIntervalState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getMin(), other.getMin()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TbMinIntervalState;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $min = Double.doubleToLongBits(this.getMin());
        result = result * 59 + (int)($min >>> 32 ^ $min);
        return result;
    }

    @Override
    public String toString() {
        return "TbMinIntervalState(min=" + this.getMin() + ")";
    }

    public TbMinIntervalState() {
    }
}

