/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.incoming.state;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.thingsboard.rule.engine.analytics.incoming.state.TbBaseIntervalState;

public class TbMaxIntervalState
extends TbBaseIntervalState {
    private double max = -1.7976931348623157E308;

    public TbMaxIntervalState(JsonElement stateJson) {
        this.max = stateJson.getAsJsonObject().get("max").getAsDouble();
    }

    @Override
    protected boolean doUpdate(JsonElement data) {
        double value = data.getAsDouble();
        if (value > this.max) {
            this.max = value;
            return true;
        }
        return false;
    }

    @Override
    public String toValueJson(Gson gson, String outputValueKey) {
        JsonObject json = new JsonObject();
        json.addProperty(outputValueKey, (Number)this.max);
        return gson.toJson((JsonElement)json);
    }

    @Override
    public String toStateJson(Gson gson) {
        JsonObject object = new JsonObject();
        object.addProperty("max", (Number)this.max);
        return gson.toJson((JsonElement)object);
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbMaxIntervalState)) {
            return false;
        }
        TbMaxIntervalState other = (TbMaxIntervalState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getMax(), other.getMax()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TbMaxIntervalState;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $max = Double.doubleToLongBits(this.getMax());
        result = result * 59 + (int)($max >>> 32 ^ $max);
        return result;
    }

    @Override
    public String toString() {
        return "TbMaxIntervalState(max=" + this.getMax() + ")";
    }

    public TbMaxIntervalState() {
    }
}

