/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.incoming.state;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Set;
import org.thingsboard.rule.engine.analytics.incoming.state.TbBaseIntervalState;

public class TbCountUniqueIntervalState
extends TbBaseIntervalState {
    private Set<String> items = new HashSet<String>();

    public TbCountUniqueIntervalState(JsonElement stateJson) {
        stateJson.getAsJsonArray().forEach(jsonElement -> this.items.add(jsonElement.toString()));
    }

    @Override
    protected boolean doUpdate(JsonElement data) {
        return this.items.add(data.getAsString());
    }

    @Override
    public String toValueJson(Gson gson, String outputValueKey) {
        JsonObject json = new JsonObject();
        json.addProperty(outputValueKey, (Number)this.items.size());
        return gson.toJson((JsonElement)json);
    }

    @Override
    public String toStateJson(Gson gson) {
        JsonArray array = new JsonArray();
        this.items.forEach(item -> array.add((JsonElement)new JsonPrimitive(item)));
        return gson.toJson((JsonElement)array);
    }

    public Set<String> getItems() {
        return this.items;
    }

    public void setItems(Set<String> items) {
        this.items = items;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbCountUniqueIntervalState)) {
            return false;
        }
        TbCountUniqueIntervalState other = (TbCountUniqueIntervalState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$items = this.getItems();
        Set<String> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TbCountUniqueIntervalState;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TbCountUniqueIntervalState(items=" + this.getItems() + ")";
    }

    public TbCountUniqueIntervalState() {
    }
}

