/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.incoming.state;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.thingsboard.rule.engine.analytics.incoming.state.TbBaseIntervalState;

public class TbCountIntervalState
extends TbBaseIntervalState {
    private long count = 0L;

    public TbCountIntervalState(JsonElement stateJson) {
        this.count = stateJson.getAsJsonObject().get("count").getAsLong();
    }

    @Override
    protected boolean doUpdate(JsonElement data) {
        ++this.count;
        return true;
    }

    @Override
    public String toValueJson(Gson gson, String outputValueKey) {
        JsonObject json = new JsonObject();
        json.addProperty(outputValueKey, (Number)this.count);
        return gson.toJson((JsonElement)json);
    }

    @Override
    public String toStateJson(Gson gson) {
        JsonObject object = new JsonObject();
        object.addProperty("count", Long.toString(this.count));
        return gson.toJson((JsonElement)object);
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbCountIntervalState)) {
            return false;
        }
        TbCountIntervalState other = (TbCountIntervalState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getCount() == other.getCount();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TbCountIntervalState;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        return result;
    }

    @Override
    public String toString() {
        return "TbCountIntervalState(count=" + this.getCount() + ")";
    }

    public TbCountIntervalState() {
    }
}

