/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.incoming.state;

import com.google.gson.JsonElement;
import org.thingsboard.rule.engine.analytics.incoming.state.TbIntervalState;

abstract class TbBaseIntervalState
implements TbIntervalState {
    private boolean hasChangesToPersist = true;
    private boolean hasChangesToReport = true;

    @Override
    public void update(JsonElement value) {
        if (this.doUpdate(value)) {
            this.hasChangesToPersist = true;
            this.hasChangesToReport = true;
        }
    }

    @Override
    public boolean hasChangesToReport() {
        return this.hasChangesToReport;
    }

    @Override
    public boolean hasChangesToPersist() {
        return this.hasChangesToPersist;
    }

    @Override
    public void clearChangesToPersist() {
        this.hasChangesToPersist = false;
    }

    @Override
    public void clearChangesToReport() {
        this.hasChangesToReport = false;
    }

    protected abstract boolean doUpdate(JsonElement var1);

    public boolean isHasChangesToPersist() {
        return this.hasChangesToPersist;
    }

    public boolean isHasChangesToReport() {
        return this.hasChangesToReport;
    }

    public void setHasChangesToPersist(boolean hasChangesToPersist) {
        this.hasChangesToPersist = hasChangesToPersist;
    }

    public void setHasChangesToReport(boolean hasChangesToReport) {
        this.hasChangesToReport = hasChangesToReport;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbBaseIntervalState)) {
            return false;
        }
        TbBaseIntervalState other = (TbBaseIntervalState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasChangesToPersist() != other.isHasChangesToPersist()) {
            return false;
        }
        return this.isHasChangesToReport() == other.isHasChangesToReport();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbBaseIntervalState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasChangesToPersist() ? 79 : 97);
        result = result * 59 + (this.isHasChangesToReport() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "TbBaseIntervalState(hasChangesToPersist=" + this.isHasChangesToPersist() + ", hasChangesToReport=" + this.isHasChangesToReport() + ")";
    }
}

