/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.analytics.incoming.state;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.thingsboard.rule.engine.analytics.incoming.state.TbBaseIntervalState;

public class TbAvgIntervalState
extends TbBaseIntervalState {
    private BigDecimal sum = BigDecimal.ZERO;
    private long count = 0L;

    public TbAvgIntervalState(JsonElement stateJson) {
        JsonObject jsonObject = stateJson.getAsJsonObject();
        this.sum = new BigDecimal(jsonObject.get("sum").getAsString());
        this.count = jsonObject.get("count").getAsLong();
    }

    @Override
    protected boolean doUpdate(JsonElement data) {
        double value = data.getAsDouble();
        if (value != 0.0) {
            this.sum = this.sum.add(BigDecimal.valueOf(value));
        }
        ++this.count;
        return true;
    }

    @Override
    public String toValueJson(Gson gson, String outputValueKey) {
        JsonObject json = new JsonObject();
        json.addProperty(outputValueKey, (Number)this.sum.divide(BigDecimal.valueOf(this.count), 2, RoundingMode.HALF_UP).doubleValue());
        return gson.toJson((JsonElement)json);
    }

    @Override
    public String toStateJson(Gson gson) {
        JsonObject object = new JsonObject();
        object.addProperty("sum", this.sum.toString());
        object.addProperty("count", Long.toString(this.count));
        return gson.toJson((JsonElement)object);
    }

    public BigDecimal getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
    }

    public void setCount(long count) {
        this.count = count;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbAvgIntervalState)) {
            return false;
        }
        TbAvgIntervalState other = (TbAvgIntervalState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        BigDecimal this$sum = this.getSum();
        BigDecimal other$sum = other.getSum();
        return !(this$sum == null ? other$sum != null : !((Object)this$sum).equals(other$sum));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TbAvgIntervalState;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        BigDecimal $sum = this.getSum();
        result = result * 59 + ($sum == null ? 43 : ((Object)$sum).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TbAvgIntervalState(sum=" + this.getSum() + ", count=" + this.getCount() + ")";
    }

    public TbAvgIntervalState() {
    }
}

