/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.action.TbAbstractGroupActionNode;
import org.thingsboard.rule.engine.action.TbRemoveFromGroupConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="remove from group", configClazz=TbRemoveFromGroupConfiguration.class, nodeDescription="Removes Message Originator Entity from Entity Group", nodeDetails="Finds target Entity Group by group name pattern and then removes Originator Entity from this group.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeRemoveFromGroupConfig", icon="remove_circle")
public class TbRemoveFromGroupNode
extends TbAbstractGroupActionNode<TbRemoveFromGroupConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbRemoveFromGroupNode.class);

    @Override
    protected boolean createGroupIfNotExists() {
        return false;
    }

    @Override
    protected TbRemoveFromGroupConfiguration loadGroupNodeActionConfig(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbRemoveFromGroupConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbRemoveFromGroupConfiguration.class);
    }

    @Override
    protected void doProcessEntityGroupAction(TbContext ctx, TbMsg msg, EntityGroupId entityGroupId) {
        ctx.getPeContext().getEntityGroupService().removeEntityFromEntityGroup(ctx.getTenantId(), entityGroupId, msg.getOriginator());
    }
}

