/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.action.TbChangeOwnerNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.dao.customer.CustomerService;

@RuleNode(type=ComponentType.ACTION, name="change owner", configClazz=TbChangeOwnerNodeConfiguration.class, nodeDescription="Changes Owner of the Originator entity to the selected Owner by type (Tenant, Customer).If selected Owner type - <b>Customer:</b></br>Rule node finds target Owner by owner name pattern and then change the owner of the originator entity.</br>Rule node can create new Owner if it doesn't exist and selected checkbox 'Create new owner if not exists'.", nodeDetails="If an entity already belongs to this owner or entity owner is successfully changed - Message sent via <b>Success</b> chain, otherwise, <b>Failure</b> chain will be used.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeChangeOwnerConfig", icon="assignment_ind")
public class TbChangeOwnerNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbChangeOwnerNode.class);
    private TbChangeOwnerNodeConfiguration config;
    private LoadingCache<OwnerKey, EntityId> ownerIdCache;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbChangeOwnerNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbChangeOwnerNodeConfiguration.class);
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (this.config.getOwnerCacheExpiration() > 0L) {
            cacheBuilder.expireAfterWrite(this.config.getOwnerCacheExpiration(), TimeUnit.SECONDS);
        }
        this.ownerIdCache = cacheBuilder.build((CacheLoader)new OwnerCacheLoader(ctx, this.config.isCreateOwnerIfNotExists()));
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        this.processChangeOwner(ctx, msg);
    }

    public void destroy() {
    }

    private void processChangeOwner(TbContext ctx, TbMsg msg) {
        ListenableFuture<EntityId> ownerIdListenableFuture = this.getNewOwner(ctx, msg);
        DonAsynchron.withCallback(ownerIdListenableFuture, ownerId -> {
            try {
                this.doProcessChangeOwner(ctx, msg, (EntityId)ownerId);
                ctx.tellNext(msg, TbRelationTypes.SUCCESS);
            }
            catch (ThingsboardException e) {
                ctx.tellFailure(msg, (Throwable)e);
            }
        }, t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<EntityId> getNewOwner(TbContext ctx, TbMsg msg) {
        EntityType entityType = EntityType.valueOf((String)this.config.getOwnerType());
        String ownerName = entityType.equals((Object)EntityType.CUSTOMER) ? TbNodeUtils.processPattern((String)this.config.getOwnerNamePattern(), (TbMsg)msg) : null;
        OwnerKey key = new OwnerKey(entityType, ownerName);
        return ctx.getDbCallbackExecutor().executeAsync(() -> {
            EntityId newOwnerId = (EntityId)this.ownerIdCache.get((Object)key);
            if (newOwnerId == null) {
                throw new RuntimeException("No owner found with type '" + key.getOwnerType() + "' and name '" + key.getOwnerName() + "'.");
            }
            return newOwnerId;
        });
    }

    private void doProcessChangeOwner(TbContext ctx, TbMsg msg, EntityId ownerId) throws ThingsboardException {
        if (!ctx.getPeContext().getOwner(ctx.getTenantId(), msg.getOriginator()).equals(ownerId)) {
            ctx.getPeContext().changeEntityOwner(ctx.getTenantId(), ownerId, msg.getOriginator(), msg.getOriginator().getEntityType());
        }
    }

    private static class OwnerCacheLoader
    extends CacheLoader<OwnerKey, EntityId> {
        private final TbContext ctx;
        private final boolean createOwnerIfNotExists;

        private OwnerCacheLoader(TbContext ctx, boolean createOwnerIfNotExists) {
            this.ctx = ctx;
            this.createOwnerIfNotExists = createOwnerIfNotExists;
        }

        public EntityId load(OwnerKey ownerKey) {
            if (ownerKey.getOwnerType().equals((Object)EntityType.CUSTOMER)) {
                CustomerService customerService = this.ctx.getCustomerService();
                Optional customerOptional = customerService.findCustomerByTenantIdAndTitle(this.ctx.getTenantId(), ownerKey.getOwnerName());
                if (customerOptional.isPresent()) {
                    Customer customer = (Customer)customerOptional.get();
                    return (EntityId)customer.getId();
                }
                if (this.createOwnerIfNotExists) {
                    Customer newCustomer = new Customer();
                    newCustomer.setTitle(ownerKey.getOwnerName());
                    newCustomer.setTenantId(this.ctx.getTenantId());
                    Customer customer = customerService.saveCustomer(newCustomer);
                    return (EntityId)customer.getId();
                }
                return null;
            }
            return this.ctx.getTenantId();
        }
    }

    private static class OwnerKey {
        private EntityType ownerType;
        private String ownerName;

        public EntityType getOwnerType() {
            return this.ownerType;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public void setOwnerType(EntityType ownerType) {
            this.ownerType = ownerType;
        }

        public void setOwnerName(String ownerName) {
            this.ownerName = ownerName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OwnerKey)) {
                return false;
            }
            OwnerKey other = (OwnerKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EntityType this$ownerType = this.getOwnerType();
            EntityType other$ownerType = other.getOwnerType();
            if (this$ownerType == null ? other$ownerType != null : !this$ownerType.equals(other$ownerType)) {
                return false;
            }
            String this$ownerName = this.getOwnerName();
            String other$ownerName = other.getOwnerName();
            return !(this$ownerName == null ? other$ownerName != null : !this$ownerName.equals(other$ownerName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OwnerKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EntityType $ownerType = this.getOwnerType();
            result = result * 59 + ($ownerType == null ? 43 : $ownerType.hashCode());
            String $ownerName = this.getOwnerName();
            result = result * 59 + ($ownerName == null ? 43 : $ownerName.hashCode());
            return result;
        }

        public String toString() {
            return "TbChangeOwnerNode.OwnerKey(ownerType=" + this.getOwnerType() + ", ownerName=" + this.getOwnerName() + ")";
        }

        @ConstructorProperties(value={"ownerType", "ownerName"})
        public OwnerKey(EntityType ownerType, String ownerName) {
            this.ownerType = ownerType;
            this.ownerName = ownerName;
        }
    }
}

