/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.action.TbAbstractGroupActionNode;
import org.thingsboard.rule.engine.action.TbAddToGroupConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="add to group", configClazz=TbAddToGroupConfiguration.class, nodeDescription="Adds Message Originator Entity to Entity Group", nodeDetails="Finds target Entity Group by group name pattern and then adds Originator Entity to this group. Will create new Entity Group if it doesn't exists and 'Create new group if not exists' is set to true.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeAddToGroupConfig", icon="add_circle")
public class TbAddToGroupNode
extends TbAbstractGroupActionNode<TbAddToGroupConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbAddToGroupNode.class);

    @Override
    protected boolean createGroupIfNotExists() {
        return ((TbAddToGroupConfiguration)this.config).isCreateGroupIfNotExists();
    }

    @Override
    protected TbAddToGroupConfiguration loadGroupNodeActionConfig(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbAddToGroupConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbAddToGroupConfiguration.class);
    }

    @Override
    protected void doProcessEntityGroupAction(TbContext ctx, TbMsg msg, EntityGroupId entityGroupId) {
        if (BooleanUtils.toBooleanDefaultIfNull((Boolean)((TbAddToGroupConfiguration)this.config).isRemoveFromCurrentGroups(), (boolean)false)) {
            this.removeFromCurrentGroups(ctx, msg, entityGroupId);
        }
        this.addEntityToGroup(ctx, msg, entityGroupId);
    }

    private void removeFromCurrentGroups(TbContext ctx, TbMsg msg, EntityGroupId entityGroupId) {
        DonAsynchron.withCallback((ListenableFuture)Futures.allAsList(this.getListenableFutures(ctx, msg)), containerList -> this.processRemove(ctx, msg, entityGroupId, (List<EntityGroupContainer>)containerList), throwable -> {
            throw new RuntimeException((Throwable)throwable);
        });
    }

    private void processRemove(TbContext ctx, TbMsg msg, EntityGroupId entityGroupId, List<EntityGroupContainer> containerList) {
        if (!containerList.isEmpty()) {
            this.process(ctx, msg, entityGroupId, containerList, this.getAllGroupId(containerList));
        }
    }

    private EntityGroupId getAllGroupId(List<EntityGroupContainer> containerList) {
        for (EntityGroupContainer groupContainer : containerList) {
            if (groupContainer != null) {
                if (!groupContainer.isGroupAll() || groupContainer.getEntityGroupIds().isEmpty()) continue;
                return groupContainer.getEntityGroupIds().get(0);
            }
            throw new RuntimeException("Entity Group 'All' doesn't exist");
        }
        throw new RuntimeException("Entity Group 'All' doesn't exist");
    }

    private void process(TbContext ctx, TbMsg msg, EntityGroupId entityGroupId, List<EntityGroupContainer> containerList, EntityGroupId groupAllId) {
        for (EntityGroupContainer group : containerList) {
            if (group.isGroupAll() || group.getEntityGroupIds().isEmpty()) continue;
            for (EntityGroupId groupId : group.getEntityGroupIds()) {
                if (groupId.equals((Object)entityGroupId) || groupId.equals((Object)groupAllId)) continue;
                ctx.getPeContext().getEntityGroupService().removeEntityFromEntityGroup(ctx.getTenantId(), groupId, msg.getOriginator());
            }
        }
    }

    private List<ListenableFuture<EntityGroupContainer>> getListenableFutures(TbContext ctx, TbMsg msg) {
        ArrayList<ListenableFuture<EntityGroupContainer>> futures = new ArrayList<ListenableFuture<EntityGroupContainer>>();
        futures.add(Futures.transform((ListenableFuture)ctx.getPeContext().getEntityGroupService().findEntityGroupsForEntity(ctx.getTenantId(), msg.getOriginator()), list -> new EntityGroupContainer((List<EntityGroupId>)list, false), (Executor)ctx.getDbCallbackExecutor()));
        futures.add(Futures.transform(this.getEntityGroupAllListenableFuture(ctx, msg), entityGroupAll -> entityGroupAll.map(entityGroup -> new EntityGroupContainer(Collections.singletonList((EntityGroupId)entityGroup.getId()), true)).orElse(null), (Executor)ctx.getDbCallbackExecutor()));
        return futures;
    }

    private ListenableFuture<Optional<EntityGroup>> getEntityGroupAllListenableFuture(TbContext ctx, TbMsg msg) {
        switch (msg.getOriginator().getEntityType()) {
            case DEVICE: {
                ListenableFuture deviceListenableFuture = ctx.getDeviceService().findDeviceByIdAsync(ctx.getTenantId(), new DeviceId(msg.getOriginator().getId()));
                return Futures.transformAsync((ListenableFuture)deviceListenableFuture, device -> {
                    if (device != null) {
                        return ctx.getPeContext().getEntityGroupService().findEntityGroupByTypeAndName(ctx.getTenantId(), device.getOwnerId(), EntityType.DEVICE, "All");
                    }
                    return Futures.immediateFuture(Optional.empty());
                }, (Executor)ctx.getDbCallbackExecutor());
            }
            case ASSET: {
                ListenableFuture assetListenableFuture = ctx.getAssetService().findAssetByIdAsync(ctx.getTenantId(), new AssetId(msg.getOriginator().getId()));
                return Futures.transformAsync((ListenableFuture)assetListenableFuture, asset -> {
                    if (asset != null) {
                        return ctx.getPeContext().getEntityGroupService().findEntityGroupByTypeAndName(ctx.getTenantId(), asset.getOwnerId(), EntityType.ASSET, "All");
                    }
                    return Futures.immediateFuture(Optional.empty());
                }, (Executor)ctx.getDbCallbackExecutor());
            }
            case CUSTOMER: {
                ListenableFuture customerListenableFuture = ctx.getCustomerService().findCustomerByIdAsync(ctx.getTenantId(), new CustomerId(msg.getOriginator().getId()));
                return Futures.transformAsync((ListenableFuture)customerListenableFuture, customer -> {
                    if (customer != null) {
                        return ctx.getPeContext().getEntityGroupService().findEntityGroupByTypeAndName(ctx.getTenantId(), customer.getOwnerId(), EntityType.CUSTOMER, "All");
                    }
                    return Futures.immediateFuture(Optional.empty());
                }, (Executor)ctx.getDbCallbackExecutor());
            }
            case ENTITY_VIEW: {
                ListenableFuture entityViewListenableFuture = ctx.getEntityViewService().findEntityViewByIdAsync(ctx.getTenantId(), new EntityViewId(msg.getOriginator().getId()));
                return Futures.transformAsync((ListenableFuture)entityViewListenableFuture, entityView -> {
                    if (entityView != null) {
                        return ctx.getPeContext().getEntityGroupService().findEntityGroupByTypeAndName(ctx.getTenantId(), entityView.getOwnerId(), EntityType.ENTITY_VIEW, "All");
                    }
                    return Futures.immediateFuture(Optional.empty());
                }, (Executor)ctx.getDbCallbackExecutor());
            }
            case DASHBOARD: {
                ListenableFuture dashboardListenableFuture = ctx.getDashboardService().findDashboardByIdAsync(ctx.getTenantId(), new DashboardId(msg.getOriginator().getId()));
                return Futures.transformAsync((ListenableFuture)dashboardListenableFuture, dashboard -> {
                    if (dashboard != null) {
                        return ctx.getPeContext().getEntityGroupService().findEntityGroupByTypeAndName(ctx.getTenantId(), dashboard.getOwnerId(), EntityType.DASHBOARD, "All");
                    }
                    return Futures.immediateFuture(Optional.empty());
                }, (Executor)ctx.getDbCallbackExecutor());
            }
        }
        throw new RuntimeException("Entity with EntityType: '" + msg.getOriginator().getEntityType() + "'  doesn't support grouping");
    }

    private void addEntityToGroup(TbContext ctx, TbMsg msg, EntityGroupId entityGroupId) {
        ctx.getPeContext().getEntityGroupService().addEntityToEntityGroup(ctx.getTenantId(), entityGroupId, msg.getOriginator());
    }

    private static class EntityGroupContainer {
        private List<EntityGroupId> entityGroupIds;
        private boolean groupAll;

        public List<EntityGroupId> getEntityGroupIds() {
            return this.entityGroupIds;
        }

        public boolean isGroupAll() {
            return this.groupAll;
        }

        public void setEntityGroupIds(List<EntityGroupId> entityGroupIds) {
            this.entityGroupIds = entityGroupIds;
        }

        public void setGroupAll(boolean groupAll) {
            this.groupAll = groupAll;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityGroupContainer)) {
                return false;
            }
            EntityGroupContainer other = (EntityGroupContainer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isGroupAll() != other.isGroupAll()) {
                return false;
            }
            List<EntityGroupId> this$entityGroupIds = this.getEntityGroupIds();
            List<EntityGroupId> other$entityGroupIds = other.getEntityGroupIds();
            return !(this$entityGroupIds == null ? other$entityGroupIds != null : !((Object)this$entityGroupIds).equals(other$entityGroupIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EntityGroupContainer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isGroupAll() ? 79 : 97);
            List<EntityGroupId> $entityGroupIds = this.getEntityGroupIds();
            result = result * 59 + ($entityGroupIds == null ? 43 : ((Object)$entityGroupIds).hashCode());
            return result;
        }

        public String toString() {
            return "TbAddToGroupNode.EntityGroupContainer(entityGroupIds=" + this.getEntityGroupIds() + ", groupAll=" + this.isGroupAll() + ")";
        }

        @ConstructorProperties(value={"entityGroupIds", "groupAll"})
        public EntityGroupContainer(List<EntityGroupId> entityGroupIds, boolean groupAll) {
            this.entityGroupIds = entityGroupIds;
            this.groupAll = groupAll;
        }
    }
}

