/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.action;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.action.TbAbstractGroupActionConfigration;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.dao.group.EntityGroupService;

public abstract class TbAbstractGroupActionNode<C extends TbAbstractGroupActionConfigration>
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbAbstractGroupActionNode.class);
    protected C config;
    private LoadingCache<GroupKey, Optional<EntityGroupId>> groupIdCache;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = this.loadGroupNodeActionConfig(configuration);
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (((TbAbstractGroupActionConfigration)this.config).getGroupCacheExpiration() > 0L) {
            cacheBuilder.expireAfterWrite(((TbAbstractGroupActionConfigration)this.config).getGroupCacheExpiration(), TimeUnit.SECONDS);
        }
        this.groupIdCache = cacheBuilder.build((CacheLoader)new EntityGroupCacheLoader(ctx, this.createGroupIfNotExists()));
    }

    protected abstract boolean createGroupIfNotExists();

    protected abstract C loadGroupNodeActionConfig(TbNodeConfiguration var1) throws TbNodeException;

    public void onMsg(TbContext ctx, TbMsg msg) {
        DonAsynchron.withCallback(this.processEntityGroupAction(ctx, msg), m -> ctx.tellNext(msg, "Success"), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Void> processEntityGroupAction(TbContext ctx, TbMsg msg) {
        EntityId ownerId = ctx.getPeContext().getOwner(ctx.getTenantId(), msg.getOriginator());
        if (ownerId == null) {
            ownerId = ctx.getTenantId();
        }
        ListenableFuture<EntityGroupId> entityGroupIdFeature = this.getEntityGroup(ctx, msg, ownerId);
        return Futures.transform(entityGroupIdFeature, entityGroupId -> {
            this.doProcessEntityGroupAction(ctx, msg, (EntityGroupId)entityGroupId);
            return null;
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    protected abstract void doProcessEntityGroupAction(TbContext var1, TbMsg var2, EntityGroupId var3);

    private ListenableFuture<EntityGroupId> getEntityGroup(TbContext ctx, TbMsg msg, EntityId ownerId) {
        String groupName = TbNodeUtils.processPattern((String)((TbAbstractGroupActionConfigration)this.config).getGroupNamePattern(), (TbMsg)msg);
        GroupKey key = new GroupKey(msg.getOriginator().getEntityType(), groupName, ownerId);
        return ctx.getDbCallbackExecutor().executeAsync(() -> {
            Optional groupId = (Optional)this.groupIdCache.get((Object)key);
            if (!groupId.isPresent()) {
                throw new RuntimeException("No entity group found with type '" + key.getGroupType() + " ' and name '" + key.getGroupName() + "'.");
            }
            return (EntityGroupId)groupId.get();
        });
    }

    public void destroy() {
    }

    private static class EntityGroupCacheLoader
    extends CacheLoader<GroupKey, Optional<EntityGroupId>> {
        private final TbContext ctx;
        private final boolean createIfNotExists;

        private EntityGroupCacheLoader(TbContext ctx, boolean createIfNotExists) {
            this.ctx = ctx;
            this.createIfNotExists = createIfNotExists;
        }

        public Optional<EntityGroupId> load(GroupKey key) throws Exception {
            EntityGroupService service = this.ctx.getPeContext().getEntityGroupService();
            Optional entityGroup = (Optional)service.findEntityGroupByTypeAndName(this.ctx.getTenantId(), key.getOwnerId(), key.getGroupType(), key.getGroupName()).get();
            if (entityGroup.isPresent()) {
                return Optional.of((EntityGroupId)((EntityGroup)entityGroup.get()).getId());
            }
            if (this.createIfNotExists) {
                EntityGroup newGroup = new EntityGroup();
                newGroup.setName(key.getGroupName());
                newGroup.setType(key.getGroupType());
                return Optional.of((EntityGroupId)service.saveEntityGroup(this.ctx.getTenantId(), key.getOwnerId(), newGroup).getId());
            }
            return Optional.empty();
        }
    }

    private static class GroupKey {
        private EntityType groupType;
        private String groupName;
        private EntityId ownerId;

        public EntityType getGroupType() {
            return this.groupType;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public EntityId getOwnerId() {
            return this.ownerId;
        }

        public void setGroupType(EntityType groupType) {
            this.groupType = groupType;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public void setOwnerId(EntityId ownerId) {
            this.ownerId = ownerId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupKey)) {
                return false;
            }
            GroupKey other = (GroupKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EntityType this$groupType = this.getGroupType();
            EntityType other$groupType = other.getGroupType();
            if (this$groupType == null ? other$groupType != null : !this$groupType.equals(other$groupType)) {
                return false;
            }
            String this$groupName = this.getGroupName();
            String other$groupName = other.getGroupName();
            if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
                return false;
            }
            EntityId this$ownerId = this.getOwnerId();
            EntityId other$ownerId = other.getOwnerId();
            return !(this$ownerId == null ? other$ownerId != null : !this$ownerId.equals(other$ownerId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EntityType $groupType = this.getGroupType();
            result = result * 59 + ($groupType == null ? 43 : $groupType.hashCode());
            String $groupName = this.getGroupName();
            result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
            EntityId $ownerId = this.getOwnerId();
            result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
            return result;
        }

        public String toString() {
            return "TbAbstractGroupActionNode.GroupKey(groupType=" + this.getGroupType() + ", groupName=" + this.getGroupName() + ", ownerId=" + this.getOwnerId() + ")";
        }

        @ConstructorProperties(value={"groupType", "groupName", "ownerId"})
        public GroupKey(EntityType groupType, String groupName, EntityId ownerId) {
            this.groupType = groupType;
            this.groupName = groupName;
            this.ownerId = ownerId;
        }
    }
}

