/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.util;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;

public class EntitiesTenantIdAsyncLoader {
    public static ListenableFuture<TenantId> findEntityIdAsync(TbContext ctx, EntityId original) {
        switch (original.getEntityType()) {
            case TENANT: {
                return Futures.immediateFuture((Object)((TenantId)original));
            }
            case CUSTOMER: {
                return EntitiesTenantIdAsyncLoader.getTenantAsync(ctx.getCustomerService().findCustomerByIdAsync(ctx.getTenantId(), (CustomerId)original));
            }
            case USER: {
                return EntitiesTenantIdAsyncLoader.getTenantAsync(ctx.getUserService().findUserByIdAsync(ctx.getTenantId(), (UserId)original));
            }
            case ASSET: {
                return EntitiesTenantIdAsyncLoader.getTenantAsync(ctx.getAssetService().findAssetByIdAsync(ctx.getTenantId(), (AssetId)original));
            }
            case DEVICE: {
                return EntitiesTenantIdAsyncLoader.getTenantAsync(ctx.getDeviceService().findDeviceByIdAsync(ctx.getTenantId(), (DeviceId)original));
            }
            case ALARM: {
                return EntitiesTenantIdAsyncLoader.getTenantAsync(ctx.getAlarmService().findAlarmByIdAsync(ctx.getTenantId(), (AlarmId)original));
            }
            case RULE_CHAIN: {
                return EntitiesTenantIdAsyncLoader.getTenantAsync(ctx.getRuleChainService().findRuleChainByIdAsync(ctx.getTenantId(), (RuleChainId)original));
            }
        }
        return Futures.immediateFailedFuture((Throwable)new TbNodeException("Unexpected original EntityType " + original));
    }

    private static <T extends HasTenantId> ListenableFuture<TenantId> getTenantAsync(ListenableFuture<T> future) {
        return Futures.transformAsync(future, in -> in != null ? Futures.immediateFuture((Object)in.getTenantId()) : Futures.immediateFuture(null), (Executor)MoreExecutors.directExecutor());
    }
}

