/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.util;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.EntityId;

public class EntitiesAlarmOriginatorIdAsyncLoader {
    public static ListenableFuture<EntityId> findEntityIdAsync(TbContext ctx, EntityId original) {
        switch (original.getEntityType()) {
            case ALARM: {
                return EntitiesAlarmOriginatorIdAsyncLoader.getAlarmOriginatorAsync((ListenableFuture<Alarm>)ctx.getAlarmService().findAlarmByIdAsync(ctx.getTenantId(), (AlarmId)original));
            }
        }
        return Futures.immediateFailedFuture((Throwable)new TbNodeException("Unexpected original EntityType " + original));
    }

    private static ListenableFuture<EntityId> getAlarmOriginatorAsync(ListenableFuture<Alarm> future) {
        return Futures.transformAsync(future, in -> in != null ? Futures.immediateFuture((Object)in.getOriginator()) : Futures.immediateFuture(null), (Executor)MoreExecutors.directExecutor());
    }
}

