/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.telemetry;

import com.google.common.util.concurrent.FutureCallback;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.telemetry.TbMsgTimeseriesNodeConfiguration;
import org.thingsboard.rule.engine.telemetry.TelemetryNodeCallback;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.session.SessionMsgType;
import org.thingsboard.server.common.transport.adaptor.JsonConverter;

@RuleNode(type=ComponentType.ACTION, name="save timeseries", configClazz=TbMsgTimeseriesNodeConfiguration.class, nodeDescription="Saves timeseries data", nodeDetails="Saves timeseries telemetry data based on configurable TTL parameter. Expects messages with 'POST_TELEMETRY_REQUEST' message type", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeTimeseriesConfig", icon="file_upload")
public class TbMsgTimeseriesNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgTimeseriesNode.class);
    private TbMsgTimeseriesNodeConfiguration config;
    private TbContext ctx;
    private long tenantProfileDefaultStorageTtl;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgTimeseriesNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgTimeseriesNodeConfiguration.class);
        this.ctx = ctx;
        ctx.addTenantProfileListener(this::onTenantProfileUpdate);
        this.onTenantProfileUpdate(ctx.getTenantProfile());
    }

    void onTenantProfileUpdate(TenantProfile tenantProfile) {
        DefaultTenantProfileConfiguration configuration = (DefaultTenantProfileConfiguration)tenantProfile.getProfileData().getConfiguration();
        this.tenantProfileDefaultStorageTtl = TimeUnit.DAYS.toSeconds(configuration.getDefaultStorageTtlDays());
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        long ttl;
        if (!msg.getType().equals(SessionMsgType.POST_TELEMETRY_REQUEST.name())) {
            ctx.tellFailure(msg, (Throwable)new IllegalArgumentException("Unsupported msg type: " + msg.getType()));
            return;
        }
        long ts = TbMsgTimeseriesNode.getTs(msg);
        String src = msg.getData();
        Map tsKvMap = JsonConverter.convertToTelemetry((JsonElement)new JsonParser().parse(src), (long)ts);
        if (tsKvMap.isEmpty()) {
            ctx.tellFailure(msg, (Throwable)new IllegalArgumentException("Msg body is empty: " + src));
            return;
        }
        ArrayList<BasicTsKvEntry> tsKvEntryList = new ArrayList<BasicTsKvEntry>();
        for (Map.Entry tsKvEntry : tsKvMap.entrySet()) {
            for (KvEntry kvEntry : (List)tsKvEntry.getValue()) {
                tsKvEntryList.add(new BasicTsKvEntry(((Long)tsKvEntry.getKey()).longValue(), kvEntry));
            }
        }
        String ttlValue = msg.getMetaData().getValue("TTL");
        long l = ttl = !StringUtils.isEmpty((Object)ttlValue) ? Long.parseLong(ttlValue) : this.config.getDefaultTTL();
        if (ttl == 0L) {
            ttl = this.tenantProfileDefaultStorageTtl;
        }
        ctx.getTelemetryService().saveAndNotify(ctx.getTenantId(), msg.getOriginator(), tsKvEntryList, ttl, (FutureCallback)new TelemetryNodeCallback(ctx, msg));
    }

    public static long getTs(TbMsg msg) {
        long ts = -1L;
        String tsStr = msg.getMetaData().getValue("ts");
        if (!StringUtils.isEmpty((Object)tsStr)) {
            try {
                ts = Long.parseLong(tsStr);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            ts = msg.getTs();
        }
        return ts;
    }

    public void destroy() {
        this.ctx.removeListeners();
    }
}

