/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.sms;

import com.google.common.util.concurrent.ListenableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.sms.SmsSender;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.sms.TbSendSmsNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.EXTERNAL, name="send sms", configClazz=TbSendSmsNodeConfiguration.class, nodeDescription="Sends SMS message via SMS provider.", nodeDetails="Will send SMS message by populating target phone numbers and sms message fields using values derived from message metadata.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeSendSmsConfig", icon="sms")
public class TbSendSmsNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbSendSmsNode.class);
    private TbSendSmsNodeConfiguration config;
    private SmsSender smsSender;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        try {
            this.config = (TbSendSmsNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbSendSmsNodeConfiguration.class);
            if (!this.config.isUseSystemSmsSettings()) {
                this.smsSender = this.createSmsSender(ctx);
            }
        }
        catch (Exception e) {
            throw new TbNodeException(e);
        }
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        try {
            DonAsynchron.withCallback((ListenableFuture)ctx.getSmsExecutor().executeAsync(() -> {
                this.sendSms(ctx, msg);
                return null;
            }), ok -> ctx.tellSuccess(msg), fail -> ctx.tellFailure(msg, fail));
        }
        catch (Exception ex) {
            ctx.tellFailure(msg, (Throwable)ex);
        }
    }

    private void sendSms(TbContext ctx, TbMsg msg) throws Exception {
        String numbersTo = TbNodeUtils.processPattern((String)this.config.getNumbersToTemplate(), (TbMsgMetaData)msg.getMetaData());
        String message = TbNodeUtils.processPattern((String)this.config.getSmsMessageTemplate(), (TbMsgMetaData)msg.getMetaData());
        String[] numbersToList = numbersTo.split(",");
        if (this.config.isUseSystemSmsSettings()) {
            ctx.getSmsService().sendSms(ctx.getTenantId(), numbersToList, message);
        } else {
            for (String numberTo : numbersToList) {
                this.smsSender.sendSms(numberTo, message);
            }
        }
    }

    public void destroy() {
        if (this.smsSender != null) {
            this.smsSender.destroy();
        }
    }

    private SmsSender createSmsSender(TbContext ctx) {
        return ctx.getSmsSenderFactory().createSmsSender(this.config.getSmsProviderConfiguration());
    }
}

