/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.rpc;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.rpc.TbSendRpcReplyNodeConfiguration;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="rpc call reply", configClazz=TbSendRpcReplyNodeConfiguration.class, nodeDescription="Sends reply to RPC call from device", nodeDetails="Expects messages with any message type. Will forward message body to the device.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeRpcReplyConfig", icon="call_merge")
public class TbSendRPCReplyNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbSendRPCReplyNode.class);
    private TbSendRpcReplyNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbSendRpcReplyNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbSendRpcReplyNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        String serviceIdStr = msg.getMetaData().getValue(this.config.getServiceIdMetaDataAttribute());
        String sessionIdStr = msg.getMetaData().getValue(this.config.getSessionIdMetaDataAttribute());
        String requestIdStr = msg.getMetaData().getValue(this.config.getRequestIdMetaDataAttribute());
        if (msg.getOriginator().getEntityType() != EntityType.DEVICE) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Message originator is not a device entity!"));
        } else if (StringUtils.isEmpty((Object)requestIdStr)) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Request id is not present in the metadata!"));
        } else if (StringUtils.isEmpty((Object)serviceIdStr)) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Service id is not present in the metadata!"));
        } else if (StringUtils.isEmpty((Object)sessionIdStr)) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Session id is not present in the metadata!"));
        } else if (StringUtils.isEmpty((Object)msg.getData())) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Request body is empty!"));
        } else {
            ctx.getRpcService().sendRpcReplyToDevice(serviceIdStr, UUID.fromString(sessionIdStr), Integer.parseInt(requestIdStr), msg.getData());
            ctx.tellSuccess(msg);
        }
    }

    public void destroy() {
    }
}

