/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.rest;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.client.HttpAsyncClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsAsyncClientHttpRequestFactory;
import org.springframework.http.client.Netty4ClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.HttpClientErrorException;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.credentials.BasicCredentials;
import org.thingsboard.rule.engine.credentials.ClientCredentials;
import org.thingsboard.rule.engine.credentials.CredentialsType;
import org.thingsboard.rule.engine.rest.TbRestApiCallNodeConfiguration;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

public class TbHttpClient {
    private static final Logger log = LoggerFactory.getLogger(TbHttpClient.class);
    private static final String STATUS = "status";
    private static final String STATUS_CODE = "statusCode";
    private static final String STATUS_REASON = "statusReason";
    private static final String ERROR = "error";
    private static final String ERROR_BODY = "error_body";
    private static final String ERROR_SYSTEM_PROPERTIES = "Didn't set any system proxy properties. Should be added next system proxy properties: \"http.proxyHost\" and \"http.proxyPort\" or  \"https.proxyHost\" and \"https.proxyPort\" or \"socksProxyHost\" and \"socksProxyPort\"";
    private final TbRestApiCallNodeConfiguration config;
    private EventLoopGroup eventLoopGroup;
    private AsyncRestTemplate httpClient;
    private Deque<ListenableFuture<ResponseEntity<String>>> pendingFutures;

    TbHttpClient(TbRestApiCallNodeConfiguration config) throws TbNodeException {
        try {
            this.config = config;
            if (config.getMaxParallelRequestsCount() > 0) {
                this.pendingFutures = new ConcurrentLinkedDeque<ListenableFuture<ResponseEntity<String>>>();
            }
            if (config.isEnableProxy()) {
                CloseableHttpAsyncClient asyncClient;
                TbHttpClient.checkProxyHost(config.getProxyHost());
                TbHttpClient.checkProxyPort(config.getProxyPort());
                HttpComponentsAsyncClientHttpRequestFactory requestFactory = new HttpComponentsAsyncClientHttpRequestFactory();
                if (config.isUseSystemProxyProperties()) {
                    this.checkSystemProxyProperties();
                    asyncClient = HttpAsyncClients.createSystem();
                    final String proxyUser = System.getProperty("tb.proxy.user");
                    final String proxyPassword = System.getProperty("tb.proxy.password");
                    if (this.useAuth(proxyUser, proxyPassword)) {
                        Authenticator.setDefault(new Authenticator(){

                            @Override
                            protected PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                            }
                        });
                    }
                } else {
                    String proxyPassword;
                    HttpAsyncClientBuilder httpAsyncClientBuilder = HttpAsyncClientBuilder.create().setSSLHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier()).setSSLContext(SSLContext.getDefault()).setProxy(new HttpHost(config.getProxyHost(), config.getProxyPort(), config.getProxyScheme()));
                    String proxyUser = config.getProxyUser();
                    if (this.useAuth(proxyUser, proxyPassword = config.getProxyPassword())) {
                        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                        credsProvider.setCredentials(new AuthScope(config.getProxyHost(), config.getProxyPort()), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                        httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                    }
                    asyncClient = httpAsyncClientBuilder.build();
                }
                requestFactory.setAsyncClient((HttpAsyncClient)asyncClient);
                requestFactory.setReadTimeout(config.getReadTimeoutMs());
                this.httpClient = new AsyncRestTemplate((AsyncClientHttpRequestFactory)requestFactory);
            } else if (config.isUseSimpleClientHttpFactory()) {
                if (CredentialsType.CERT_PEM == config.getCredentials().getType()) {
                    throw new TbNodeException("Simple HTTP Factory does not support CERT PEM credentials!");
                }
                this.httpClient = new AsyncRestTemplate();
            } else {
                this.eventLoopGroup = new NioEventLoopGroup();
                Netty4ClientHttpRequestFactory nettyFactory = new Netty4ClientHttpRequestFactory(this.eventLoopGroup);
                nettyFactory.setSslContext(config.getCredentials().initSslContext());
                nettyFactory.setReadTimeout(config.getReadTimeoutMs());
                this.httpClient = new AsyncRestTemplate((AsyncClientHttpRequestFactory)nettyFactory);
            }
        }
        catch (NoSuchAlgorithmException | SSLException e) {
            throw new TbNodeException(e);
        }
    }

    private void checkSystemProxyProperties() throws TbNodeException {
        boolean useSocksProxy;
        boolean useHttpProxy = !StringUtils.isEmpty((Object)System.getProperty("http.proxyHost")) && !StringUtils.isEmpty((Object)System.getProperty("http.proxyPort"));
        boolean useHttpsProxy = !StringUtils.isEmpty((Object)System.getProperty("https.proxyHost")) && !StringUtils.isEmpty((Object)System.getProperty("https.proxyPort"));
        boolean bl = useSocksProxy = !StringUtils.isEmpty((Object)System.getProperty("socksProxyHost")) && !StringUtils.isEmpty((Object)System.getProperty("socksProxyPort"));
        if (!(useHttpProxy || useHttpsProxy || useSocksProxy)) {
            log.warn(ERROR_SYSTEM_PROPERTIES);
            throw new TbNodeException(ERROR_SYSTEM_PROPERTIES);
        }
    }

    private boolean useAuth(String proxyUser, String proxyPassword) {
        return !StringUtils.isEmpty((Object)proxyUser) && !StringUtils.isEmpty((Object)proxyPassword);
    }

    void destroy() {
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        }
    }

    public void processMessage(final TbContext ctx, final TbMsg msg) {
        String endpointUrl = TbNodeUtils.processPattern((String)this.config.getRestEndpointUrlPattern(), (TbMsgMetaData)msg.getMetaData());
        HttpHeaders headers = this.prepareHeaders(msg.getMetaData());
        HttpMethod method = HttpMethod.valueOf((String)this.config.getRequestMethod());
        HttpEntity entity = new HttpEntity((Object)msg.getData(), (MultiValueMap)headers);
        ListenableFuture future = this.httpClient.exchange(endpointUrl, method, entity, String.class, new Object[0]);
        future.addCallback((ListenableFutureCallback)new ListenableFutureCallback<ResponseEntity<String>>(){

            public void onFailure(Throwable throwable) {
                TbMsg next = TbHttpClient.this.processException(ctx, msg, throwable);
                ctx.tellFailure(next, throwable);
            }

            public void onSuccess(ResponseEntity<String> responseEntity) {
                if (responseEntity.getStatusCode().is2xxSuccessful()) {
                    TbMsg next = TbHttpClient.this.processResponse(ctx, msg, (ResponseEntity<String>)responseEntity);
                    ctx.tellSuccess(next);
                } else {
                    TbMsg next = TbHttpClient.this.processFailureResponse(ctx, msg, (ResponseEntity<String>)responseEntity);
                    ctx.tellNext(next, TbRelationTypes.FAILURE);
                }
            }
        });
        if (this.pendingFutures != null) {
            this.processParallelRequests((ListenableFuture<ResponseEntity<String>>)future);
        }
    }

    private TbMsg processResponse(TbContext ctx, TbMsg origMsg, ResponseEntity<String> response) {
        TbMsgMetaData metaData = origMsg.getMetaData();
        metaData.putValue(STATUS, response.getStatusCode().name());
        metaData.putValue(STATUS_CODE, response.getStatusCode().value() + "");
        metaData.putValue(STATUS_REASON, response.getStatusCode().getReasonPhrase());
        response.getHeaders().toSingleValueMap().forEach((arg_0, arg_1) -> ((TbMsgMetaData)metaData).putValue(arg_0, arg_1));
        return ctx.transformMsg(origMsg, origMsg.getType(), origMsg.getOriginator(), metaData, (String)response.getBody());
    }

    private TbMsg processFailureResponse(TbContext ctx, TbMsg origMsg, ResponseEntity<String> response) {
        TbMsgMetaData metaData = origMsg.getMetaData();
        metaData.putValue(STATUS, response.getStatusCode().name());
        metaData.putValue(STATUS_CODE, response.getStatusCode().value() + "");
        metaData.putValue(STATUS_REASON, response.getStatusCode().getReasonPhrase());
        metaData.putValue(ERROR_BODY, (String)response.getBody());
        return ctx.transformMsg(origMsg, origMsg.getType(), origMsg.getOriginator(), metaData, origMsg.getData());
    }

    private TbMsg processException(TbContext ctx, TbMsg origMsg, Throwable e) {
        TbMsgMetaData metaData = origMsg.getMetaData();
        metaData.putValue(ERROR, e.getClass() + ": " + e.getMessage());
        if (e instanceof HttpClientErrorException) {
            HttpClientErrorException httpClientErrorException = (HttpClientErrorException)e;
            metaData.putValue(STATUS, httpClientErrorException.getStatusText());
            metaData.putValue(STATUS_CODE, httpClientErrorException.getRawStatusCode() + "");
            metaData.putValue(ERROR_BODY, httpClientErrorException.getResponseBodyAsString());
        }
        return ctx.transformMsg(origMsg, origMsg.getType(), origMsg.getOriginator(), metaData, origMsg.getData());
    }

    private HttpHeaders prepareHeaders(TbMsgMetaData metaData) {
        HttpHeaders headers = new HttpHeaders();
        this.config.getHeaders().forEach((k, v) -> headers.add(TbNodeUtils.processPattern((String)k, (TbMsgMetaData)metaData), TbNodeUtils.processPattern((String)v, (TbMsgMetaData)metaData)));
        ClientCredentials credentials = this.config.getCredentials();
        if (CredentialsType.BASIC == credentials.getType()) {
            BasicCredentials basicCredentials = (BasicCredentials)credentials;
            String authString = basicCredentials.getUsername() + ":" + basicCredentials.getPassword();
            String encodedAuthString = new String(Base64.encodeBase64((byte[])authString.getBytes(StandardCharsets.UTF_8)));
            headers.add("Authorization", "Basic " + encodedAuthString);
        }
        return headers;
    }

    private void processParallelRequests(ListenableFuture<ResponseEntity<String>> future) {
        this.pendingFutures.add(future);
        if (this.pendingFutures.size() > this.config.getMaxParallelRequestsCount()) {
            for (int i = 0; i < this.config.getMaxParallelRequestsCount(); ++i) {
                try {
                    ListenableFuture<ResponseEntity<String>> pendingFuture = this.pendingFutures.removeFirst();
                    try {
                        pendingFuture.get((long)this.config.getReadTimeoutMs(), TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        log.warn("Timeout during waiting for reply!", (Throwable)e);
                        pendingFuture.cancel(true);
                    }
                    continue;
                }
                catch (Exception e) {
                    log.warn("Failure during waiting for reply!", (Throwable)e);
                }
            }
        }
    }

    private static void checkProxyHost(String proxyHost) throws TbNodeException {
        if (StringUtils.isEmpty((Object)proxyHost)) {
            throw new TbNodeException("Proxy host can't be empty");
        }
    }

    private static void checkProxyPort(int proxyPort) throws TbNodeException {
        if (proxyPort < 0 || proxyPort > 65535) {
            throw new TbNodeException("Proxy port out of range:" + proxyPort);
        }
    }

    public TbRestApiCallNodeConfiguration getConfig() {
        return this.config;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public AsyncRestTemplate getHttpClient() {
        return this.httpClient;
    }

    public Deque<ListenableFuture<ResponseEntity<String>>> getPendingFutures() {
        return this.pendingFutures;
    }

    public void setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    public void setHttpClient(AsyncRestTemplate httpClient) {
        this.httpClient = httpClient;
    }

    public void setPendingFutures(Deque<ListenableFuture<ResponseEntity<String>>> pendingFutures) {
        this.pendingFutures = pendingFutures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbHttpClient)) {
            return false;
        }
        TbHttpClient other = (TbHttpClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TbRestApiCallNodeConfiguration this$config = this.getConfig();
        TbRestApiCallNodeConfiguration other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        EventLoopGroup this$eventLoopGroup = this.getEventLoopGroup();
        EventLoopGroup other$eventLoopGroup = other.getEventLoopGroup();
        if (this$eventLoopGroup == null ? other$eventLoopGroup != null : !this$eventLoopGroup.equals(other$eventLoopGroup)) {
            return false;
        }
        AsyncRestTemplate this$httpClient = this.getHttpClient();
        AsyncRestTemplate other$httpClient = other.getHttpClient();
        if (this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient)) {
            return false;
        }
        Deque<ListenableFuture<ResponseEntity<String>>> this$pendingFutures = this.getPendingFutures();
        Deque<ListenableFuture<ResponseEntity<String>>> other$pendingFutures = other.getPendingFutures();
        return !(this$pendingFutures == null ? other$pendingFutures != null : !this$pendingFutures.equals(other$pendingFutures));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbHttpClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TbRestApiCallNodeConfiguration $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        EventLoopGroup $eventLoopGroup = this.getEventLoopGroup();
        result = result * 59 + ($eventLoopGroup == null ? 43 : $eventLoopGroup.hashCode());
        AsyncRestTemplate $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        Deque<ListenableFuture<ResponseEntity<String>>> $pendingFutures = this.getPendingFutures();
        result = result * 59 + ($pendingFutures == null ? 43 : $pendingFutures.hashCode());
        return result;
    }

    public String toString() {
        return "TbHttpClient(config=" + this.getConfig() + ", eventLoopGroup=" + this.getEventLoopGroup() + ", httpClient=" + this.getHttpClient() + ", pendingFutures=" + this.getPendingFutures() + ")";
    }
}

