/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.profile;

import org.thingsboard.server.common.data.kv.DataType;

class EntityKeyValue {
    private DataType dataType;
    private Long lngValue;
    private Double dblValue;
    private Boolean boolValue;
    private String strValue;

    EntityKeyValue() {
    }

    public Long getLngValue() {
        return this.dataType == DataType.LONG ? this.lngValue : null;
    }

    public void setLngValue(Long lngValue) {
        this.dataType = DataType.LONG;
        this.lngValue = lngValue;
    }

    public Double getDblValue() {
        return this.dataType == DataType.DOUBLE ? this.dblValue : null;
    }

    public void setDblValue(Double dblValue) {
        this.dataType = DataType.DOUBLE;
        this.dblValue = dblValue;
    }

    public Boolean getBoolValue() {
        return this.dataType == DataType.BOOLEAN ? this.boolValue : null;
    }

    public void setBoolValue(Boolean boolValue) {
        this.dataType = DataType.BOOLEAN;
        this.boolValue = boolValue;
    }

    public String getStrValue() {
        return this.dataType == DataType.STRING ? this.strValue : null;
    }

    public void setStrValue(String strValue) {
        this.dataType = DataType.STRING;
        this.strValue = strValue;
    }

    public void setJsonValue(String jsonValue) {
        this.dataType = DataType.JSON;
        this.strValue = jsonValue;
    }

    public String getJsonValue() {
        return this.dataType == DataType.JSON ? this.strValue : null;
    }

    boolean isSet() {
        return this.dataType != null;
    }

    static EntityKeyValue fromString(String s) {
        EntityKeyValue result = new EntityKeyValue();
        result.setStrValue(s);
        return result;
    }

    static EntityKeyValue fromBool(boolean b) {
        EntityKeyValue result = new EntityKeyValue();
        result.setBoolValue(b);
        return result;
    }

    static EntityKeyValue fromLong(long l) {
        EntityKeyValue result = new EntityKeyValue();
        result.setLngValue(l);
        return result;
    }

    static EntityKeyValue fromDouble(double d) {
        EntityKeyValue result = new EntityKeyValue();
        result.setDblValue(d);
        return result;
    }

    static EntityKeyValue fromJson(String s) {
        EntityKeyValue result = new EntityKeyValue();
        result.setJsonValue(s);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityKeyValue)) {
            return false;
        }
        EntityKeyValue other = (EntityKeyValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        Long this$lngValue = this.getLngValue();
        Long other$lngValue = other.getLngValue();
        if (this$lngValue == null ? other$lngValue != null : !((Object)this$lngValue).equals(other$lngValue)) {
            return false;
        }
        Double this$dblValue = this.getDblValue();
        Double other$dblValue = other.getDblValue();
        if (this$dblValue == null ? other$dblValue != null : !((Object)this$dblValue).equals(other$dblValue)) {
            return false;
        }
        Boolean this$boolValue = this.getBoolValue();
        Boolean other$boolValue = other.getBoolValue();
        if (this$boolValue == null ? other$boolValue != null : !((Object)this$boolValue).equals(other$boolValue)) {
            return false;
        }
        String this$strValue = this.getStrValue();
        String other$strValue = other.getStrValue();
        return !(this$strValue == null ? other$strValue != null : !this$strValue.equals(other$strValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityKeyValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        Long $lngValue = this.getLngValue();
        result = result * 59 + ($lngValue == null ? 43 : ((Object)$lngValue).hashCode());
        Double $dblValue = this.getDblValue();
        result = result * 59 + ($dblValue == null ? 43 : ((Object)$dblValue).hashCode());
        Boolean $boolValue = this.getBoolValue();
        result = result * 59 + ($boolValue == null ? 43 : ((Object)$boolValue).hashCode());
        String $strValue = this.getStrValue();
        result = result * 59 + ($strValue == null ? 43 : $strValue.hashCode());
        return result;
    }

    public DataType getDataType() {
        return this.dataType;
    }
}

