/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.profile;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.profile.AlarmState;
import org.thingsboard.rule.engine.profile.DataSnapshot;
import org.thingsboard.rule.engine.profile.EntityKeyValue;
import org.thingsboard.rule.engine.profile.ProfileState;
import org.thingsboard.rule.engine.profile.SnapshotUpdate;
import org.thingsboard.rule.engine.profile.TbDeviceProfileNodeConfiguration;
import org.thingsboard.rule.engine.profile.state.PersistedAlarmRuleState;
import org.thingsboard.rule.engine.profile.state.PersistedAlarmState;
import org.thingsboard.rule.engine.profile.state.PersistedDeviceState;
import org.thingsboard.rule.engine.telemetry.TbMsgTimeseriesNode;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.device.profile.DeviceProfileAlarm;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.rule.RuleNodeState;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.session.SessionMsgType;
import org.thingsboard.server.common.transport.adaptor.JsonConverter;
import org.thingsboard.server.dao.util.mapping.JacksonUtil;

class DeviceState {
    private static final Logger log = LoggerFactory.getLogger(DeviceState.class);
    private final boolean persistState;
    private final DeviceId deviceId;
    private final ProfileState deviceProfile;
    private RuleNodeState state;
    private PersistedDeviceState pds;
    private DataSnapshot latestValues;
    private final ConcurrentMap<String, AlarmState> alarmStates = new ConcurrentHashMap<String, AlarmState>();

    DeviceState(TbContext ctx, TbDeviceProfileNodeConfiguration config, DeviceId deviceId, ProfileState deviceProfile, RuleNodeState state) {
        this.persistState = config.isPersistAlarmRulesState();
        this.deviceId = deviceId;
        this.deviceProfile = deviceProfile;
        if (config.isPersistAlarmRulesState()) {
            this.state = state != null ? state : ctx.findRuleNodeStateForEntity((EntityId)deviceId);
            if (this.state != null) {
                this.pds = (PersistedDeviceState)JacksonUtil.fromString((String)this.state.getStateData(), PersistedDeviceState.class);
            } else {
                this.state = new RuleNodeState();
                this.state.setRuleNodeId(ctx.getSelfId());
                this.state.setEntityId((EntityId)deviceId);
                this.pds = new PersistedDeviceState();
                this.pds.setAlarmStates(new HashMap<String, PersistedAlarmState>());
            }
        }
        if (this.pds != null) {
            for (DeviceProfileAlarm alarm : deviceProfile.getAlarmSettings()) {
                this.alarmStates.computeIfAbsent(alarm.getId(), a -> new AlarmState(deviceProfile, (EntityId)deviceId, alarm, this.getOrInitPersistedAlarmState(alarm)));
            }
        }
    }

    public void updateProfile(TbContext ctx, DeviceProfile deviceProfile) throws ExecutionException, InterruptedException {
        Set<EntityKey> oldKeys = this.deviceProfile.getEntityKeys();
        this.deviceProfile.updateDeviceProfile(deviceProfile);
        if (this.latestValues != null) {
            HashSet<EntityKey> keysToFetch = new HashSet<EntityKey>(this.deviceProfile.getEntityKeys());
            keysToFetch.removeAll(oldKeys);
            if (!keysToFetch.isEmpty()) {
                this.addEntityKeysToSnapshot(ctx, (EntityId)this.deviceId, keysToFetch, this.latestValues);
            }
        }
        Set newAlarmStateIds = this.deviceProfile.getAlarmSettings().stream().map(DeviceProfileAlarm::getId).collect(Collectors.toSet());
        this.alarmStates.keySet().removeIf(id -> !newAlarmStateIds.contains(id));
        for (DeviceProfileAlarm alarm : this.deviceProfile.getAlarmSettings()) {
            if (this.alarmStates.containsKey(alarm.getId())) {
                ((AlarmState)this.alarmStates.get(alarm.getId())).updateState(alarm, this.getOrInitPersistedAlarmState(alarm));
                continue;
            }
            this.alarmStates.putIfAbsent(alarm.getId(), new AlarmState(this.deviceProfile, (EntityId)this.deviceId, alarm, this.getOrInitPersistedAlarmState(alarm)));
        }
    }

    public void harvestAlarms(TbContext ctx, long ts) throws ExecutionException, InterruptedException {
        log.debug("[{}] Going to harvest alarms: {}", (Object)ctx.getSelfId(), (Object)ts);
        boolean stateChanged = false;
        for (AlarmState state : this.alarmStates.values()) {
            stateChanged |= state.process(ctx, ts);
        }
        if (this.persistState && stateChanged) {
            this.state.setStateData(JacksonUtil.toString((Object)this.pds));
            this.state = ctx.saveRuleNodeState(this.state);
        }
    }

    public void process(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException {
        if (this.latestValues == null) {
            this.latestValues = this.fetchLatestValues(ctx, (EntityId)this.deviceId);
        }
        boolean stateChanged = false;
        if (msg.getType().equals(SessionMsgType.POST_TELEMETRY_REQUEST.name())) {
            stateChanged = this.processTelemetry(ctx, msg);
        } else if (msg.getType().equals(SessionMsgType.POST_ATTRIBUTES_REQUEST.name())) {
            stateChanged = this.processAttributesUpdateRequest(ctx, msg);
        } else if (msg.getType().equals("ATTRIBUTES_UPDATED")) {
            stateChanged = this.processAttributesUpdateNotification(ctx, msg);
        } else if (msg.getType().equals("ATTRIBUTES_DELETED")) {
            stateChanged = this.processAttributesDeleteNotification(ctx, msg);
        } else if (msg.getType().equals("ALARM_CLEAR")) {
            stateChanged = this.processAlarmClearNotification(ctx, msg);
        } else if (msg.getType().equals("ALARM_ACK")) {
            this.processAlarmAckNotification(ctx, msg);
        } else {
            ctx.tellSuccess(msg);
        }
        if (this.persistState && stateChanged) {
            this.state.setStateData(JacksonUtil.toString((Object)this.pds));
            this.state = ctx.saveRuleNodeState(this.state);
        }
    }

    private boolean processAlarmClearNotification(TbContext ctx, TbMsg msg) {
        boolean stateChanged = false;
        Alarm alarmNf = (Alarm)JacksonUtil.fromString((String)msg.getData(), Alarm.class);
        for (DeviceProfileAlarm alarm : this.deviceProfile.getAlarmSettings()) {
            AlarmState alarmState = this.alarmStates.computeIfAbsent(alarm.getId(), a -> new AlarmState(this.deviceProfile, (EntityId)this.deviceId, alarm, this.getOrInitPersistedAlarmState(alarm)));
            stateChanged |= alarmState.processAlarmClear(ctx, alarmNf);
        }
        ctx.tellSuccess(msg);
        return stateChanged;
    }

    private void processAlarmAckNotification(TbContext ctx, TbMsg msg) {
        Alarm alarmNf = (Alarm)JacksonUtil.fromString((String)msg.getData(), Alarm.class);
        for (DeviceProfileAlarm alarm : this.deviceProfile.getAlarmSettings()) {
            AlarmState alarmState = this.alarmStates.computeIfAbsent(alarm.getId(), a -> new AlarmState(this.deviceProfile, (EntityId)this.deviceId, alarm, this.getOrInitPersistedAlarmState(alarm)));
            alarmState.processAckAlarm(alarmNf);
        }
        ctx.tellSuccess(msg);
    }

    private boolean processAttributesUpdateNotification(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException {
        Set attributes = JsonConverter.convertToAttributes((JsonElement)new JsonParser().parse(msg.getData()));
        String scope = msg.getMetaData().getValue("scope");
        if (StringUtils.isEmpty((Object)scope)) {
            scope = "CLIENT_SCOPE";
        }
        return this.processAttributesUpdate(ctx, msg, attributes, scope);
    }

    private boolean processAttributesDeleteNotification(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException {
        boolean stateChanged = false;
        ArrayList keys = new ArrayList();
        new JsonParser().parse(msg.getData()).getAsJsonObject().get("attributes").getAsJsonArray().forEach(e -> keys.add(e.getAsString()));
        String scope = msg.getMetaData().getValue("scope");
        if (StringUtils.isEmpty((Object)scope)) {
            scope = "CLIENT_SCOPE";
        }
        if (!keys.isEmpty()) {
            EntityKeyType keyType = DeviceState.getKeyTypeFromScope(scope);
            keys.forEach(key -> this.latestValues.removeValue(new EntityKey(keyType, key)));
            for (DeviceProfileAlarm alarm : this.deviceProfile.getAlarmSettings()) {
                AlarmState alarmState = this.alarmStates.computeIfAbsent(alarm.getId(), a -> new AlarmState(this.deviceProfile, (EntityId)this.deviceId, alarm, this.getOrInitPersistedAlarmState(alarm)));
                stateChanged |= alarmState.process(ctx, msg, this.latestValues, null);
            }
        }
        ctx.tellSuccess(msg);
        return stateChanged;
    }

    protected boolean processAttributesUpdateRequest(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException {
        Set attributes = JsonConverter.convertToAttributes((JsonElement)new JsonParser().parse(msg.getData()));
        return this.processAttributesUpdate(ctx, msg, attributes, "CLIENT_SCOPE");
    }

    private boolean processAttributesUpdate(TbContext ctx, TbMsg msg, Set<AttributeKvEntry> attributes, String scope) throws ExecutionException, InterruptedException {
        boolean stateChanged = false;
        if (!attributes.isEmpty()) {
            SnapshotUpdate update = this.merge(this.latestValues, attributes, scope);
            for (DeviceProfileAlarm alarm : this.deviceProfile.getAlarmSettings()) {
                AlarmState alarmState = this.alarmStates.computeIfAbsent(alarm.getId(), a -> new AlarmState(this.deviceProfile, (EntityId)this.deviceId, alarm, this.getOrInitPersistedAlarmState(alarm)));
                stateChanged |= alarmState.process(ctx, msg, this.latestValues, update);
            }
        }
        ctx.tellSuccess(msg);
        return stateChanged;
    }

    protected boolean processTelemetry(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException {
        boolean stateChanged = false;
        Map tsKvMap = JsonConverter.convertToSortedTelemetry((JsonElement)new JsonParser().parse(msg.getData()), (long)TbMsgTimeseriesNode.getTs(msg));
        for (Map.Entry entry : tsKvMap.entrySet()) {
            List data;
            Long ts = (Long)entry.getKey();
            SnapshotUpdate update = this.merge(this.latestValues, ts, data = (List)entry.getValue());
            if (!update.hasUpdate()) continue;
            for (DeviceProfileAlarm alarm : this.deviceProfile.getAlarmSettings()) {
                AlarmState alarmState = this.alarmStates.computeIfAbsent(alarm.getId(), a -> new AlarmState(this.deviceProfile, (EntityId)this.deviceId, alarm, this.getOrInitPersistedAlarmState(alarm)));
                stateChanged |= alarmState.process(ctx, msg, this.latestValues, update);
            }
        }
        ctx.tellSuccess(msg);
        return stateChanged;
    }

    private SnapshotUpdate merge(DataSnapshot latestValues, Long newTs, List<KvEntry> data) {
        HashSet<EntityKey> keys = new HashSet<EntityKey>();
        for (KvEntry entry : data) {
            EntityKey entityKey = new EntityKey(EntityKeyType.TIME_SERIES, entry.getKey());
            if (!latestValues.putValue(entityKey, newTs, this.toEntityValue(entry))) continue;
            keys.add(entityKey);
        }
        latestValues.setTs(newTs);
        return new SnapshotUpdate(EntityKeyType.TIME_SERIES, keys);
    }

    private SnapshotUpdate merge(DataSnapshot latestValues, Set<AttributeKvEntry> attributes, String scope) {
        long newTs = 0L;
        HashSet<EntityKey> keys = new HashSet<EntityKey>();
        for (AttributeKvEntry entry : attributes) {
            newTs = Math.max(newTs, entry.getLastUpdateTs());
            EntityKey entityKey = new EntityKey(DeviceState.getKeyTypeFromScope(scope), entry.getKey());
            if (!latestValues.putValue(entityKey, newTs, this.toEntityValue((KvEntry)entry))) continue;
            keys.add(entityKey);
        }
        latestValues.setTs(newTs);
        return new SnapshotUpdate(EntityKeyType.ATTRIBUTE, keys);
    }

    private static EntityKeyType getKeyTypeFromScope(String scope) {
        switch (scope) {
            case "CLIENT_SCOPE": {
                return EntityKeyType.CLIENT_ATTRIBUTE;
            }
            case "SHARED_SCOPE": {
                return EntityKeyType.SHARED_ATTRIBUTE;
            }
            case "SERVER_SCOPE": {
                return EntityKeyType.SERVER_ATTRIBUTE;
            }
        }
        return EntityKeyType.ATTRIBUTE;
    }

    private DataSnapshot fetchLatestValues(TbContext ctx, EntityId originator) throws ExecutionException, InterruptedException {
        Set<EntityKey> entityKeysToFetch = this.deviceProfile.getEntityKeys();
        DataSnapshot result = new DataSnapshot(entityKeysToFetch);
        this.addEntityKeysToSnapshot(ctx, originator, entityKeysToFetch, result);
        return result;
    }

    private void addEntityKeysToSnapshot(TbContext ctx, EntityId originator, Set<EntityKey> entityKeysToFetch, DataSnapshot result) throws InterruptedException, ExecutionException {
        HashSet<String> serverAttributeKeys = new HashSet<String>();
        HashSet<String> clientAttributeKeys = new HashSet<String>();
        HashSet<String> sharedAttributeKeys = new HashSet<String>();
        HashSet<String> commonAttributeKeys = new HashSet<String>();
        HashSet<String> latestTsKeys = new HashSet<String>();
        Device device = null;
        for (EntityKey entityKey : entityKeysToFetch) {
            String key = entityKey.getKey();
            block0 : switch (entityKey.getType()) {
                case SERVER_ATTRIBUTE: {
                    serverAttributeKeys.add(key);
                    break;
                }
                case CLIENT_ATTRIBUTE: {
                    clientAttributeKeys.add(key);
                    break;
                }
                case SHARED_ATTRIBUTE: {
                    sharedAttributeKeys.add(key);
                    break;
                }
                case ATTRIBUTE: {
                    serverAttributeKeys.add(key);
                    clientAttributeKeys.add(key);
                    sharedAttributeKeys.add(key);
                    commonAttributeKeys.add(key);
                    break;
                }
                case TIME_SERIES: {
                    latestTsKeys.add(key);
                    break;
                }
                case ENTITY_FIELD: {
                    if (device == null) {
                        device = ctx.getDeviceService().findDeviceById(ctx.getTenantId(), new DeviceId(originator.getId()));
                    }
                    if (device == null) break;
                    switch (key) {
                        case "name": {
                            result.putValue(entityKey, device.getCreatedTime(), EntityKeyValue.fromString(device.getName()));
                            break block0;
                        }
                        case "type": {
                            result.putValue(entityKey, device.getCreatedTime(), EntityKeyValue.fromString(device.getType()));
                            break block0;
                        }
                        case "createdTime": {
                            result.putValue(entityKey, device.getCreatedTime(), EntityKeyValue.fromLong(device.getCreatedTime()));
                            break block0;
                        }
                        case "label": {
                            result.putValue(entityKey, device.getCreatedTime(), EntityKeyValue.fromString(device.getLabel()));
                        }
                    }
                }
            }
        }
        if (!latestTsKeys.isEmpty()) {
            List data = (List)ctx.getTimeseriesService().findLatest(ctx.getTenantId(), originator, latestTsKeys).get();
            for (TsKvEntry entry : data) {
                if (entry.getValue() == null) continue;
                result.putValue(new EntityKey(EntityKeyType.TIME_SERIES, entry.getKey()), entry.getTs(), this.toEntityValue((KvEntry)entry));
            }
        }
        if (!clientAttributeKeys.isEmpty()) {
            this.addToSnapshot(result, commonAttributeKeys, (List)ctx.getAttributesService().find(ctx.getTenantId(), originator, "CLIENT_SCOPE", clientAttributeKeys).get());
        }
        if (!sharedAttributeKeys.isEmpty()) {
            this.addToSnapshot(result, commonAttributeKeys, (List)ctx.getAttributesService().find(ctx.getTenantId(), originator, "SHARED_SCOPE", sharedAttributeKeys).get());
        }
        if (!serverAttributeKeys.isEmpty()) {
            this.addToSnapshot(result, commonAttributeKeys, (List)ctx.getAttributesService().find(ctx.getTenantId(), originator, "SERVER_SCOPE", serverAttributeKeys).get());
        }
    }

    private void addToSnapshot(DataSnapshot snapshot, Set<String> commonAttributeKeys, List<AttributeKvEntry> data) {
        for (AttributeKvEntry entry : data) {
            if (entry.getValue() == null) continue;
            EntityKeyValue value = this.toEntityValue((KvEntry)entry);
            snapshot.putValue(new EntityKey(EntityKeyType.CLIENT_ATTRIBUTE, entry.getKey()), entry.getLastUpdateTs(), value);
            if (!commonAttributeKeys.contains(entry.getKey())) continue;
            snapshot.putValue(new EntityKey(EntityKeyType.ATTRIBUTE, entry.getKey()), entry.getLastUpdateTs(), value);
        }
    }

    private EntityKeyValue toEntityValue(KvEntry entry) {
        switch (entry.getDataType()) {
            case STRING: {
                return EntityKeyValue.fromString((String)entry.getStrValue().get());
            }
            case LONG: {
                return EntityKeyValue.fromLong((Long)entry.getLongValue().get());
            }
            case DOUBLE: {
                return EntityKeyValue.fromDouble((Double)entry.getDoubleValue().get());
            }
            case BOOLEAN: {
                return EntityKeyValue.fromBool((Boolean)entry.getBooleanValue().get());
            }
            case JSON: {
                return EntityKeyValue.fromJson((String)entry.getJsonValue().get());
            }
        }
        throw new RuntimeException("Can't parse entry: " + entry.getDataType());
    }

    public DeviceProfileId getProfileId() {
        return this.deviceProfile.getProfileId();
    }

    private PersistedAlarmState getOrInitPersistedAlarmState(DeviceProfileAlarm alarm) {
        if (this.pds != null) {
            PersistedAlarmState alarmState = this.pds.getAlarmStates().get(alarm.getId());
            if (alarmState == null) {
                alarmState = new PersistedAlarmState();
                alarmState.setCreateRuleStates(new HashMap<AlarmSeverity, PersistedAlarmRuleState>());
                this.pds.getAlarmStates().put(alarm.getId(), alarmState);
            }
            return alarmState;
        }
        return null;
    }
}

