/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.profile;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.thingsboard.rule.engine.profile.EntityKeyValue;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;

class DataSnapshot {
    private volatile boolean ready;
    private long ts;
    private final Set<EntityKey> keys;
    private final Map<EntityKey, EntityKeyValue> values = new ConcurrentHashMap<EntityKey, EntityKeyValue>();

    DataSnapshot(Set<EntityKey> entityKeysToFetch) {
        this.keys = entityKeysToFetch;
    }

    void removeValue(EntityKey key) {
        switch (key.getType()) {
            case ATTRIBUTE: {
                this.values.remove(key);
                this.values.remove(this.getAttrKey(key, EntityKeyType.CLIENT_ATTRIBUTE));
                this.values.remove(this.getAttrKey(key, EntityKeyType.SHARED_ATTRIBUTE));
                this.values.remove(this.getAttrKey(key, EntityKeyType.SERVER_ATTRIBUTE));
                break;
            }
            case CLIENT_ATTRIBUTE: 
            case SHARED_ATTRIBUTE: 
            case SERVER_ATTRIBUTE: {
                this.values.remove(key);
                this.values.remove(this.getAttrKey(key, EntityKeyType.ATTRIBUTE));
                break;
            }
            default: {
                this.values.remove(key);
            }
        }
    }

    boolean putValue(EntityKey key, long newTs, EntityKeyValue value) {
        boolean updateOfTs = this.ts != newTs;
        boolean result = false;
        switch (key.getType()) {
            case ATTRIBUTE: {
                result |= this.putIfKeyExists(key, value, updateOfTs);
                result |= this.putIfKeyExists(this.getAttrKey(key, EntityKeyType.CLIENT_ATTRIBUTE), value, updateOfTs);
                result |= this.putIfKeyExists(this.getAttrKey(key, EntityKeyType.SHARED_ATTRIBUTE), value, updateOfTs);
                result |= this.putIfKeyExists(this.getAttrKey(key, EntityKeyType.SERVER_ATTRIBUTE), value, updateOfTs);
                break;
            }
            case CLIENT_ATTRIBUTE: 
            case SHARED_ATTRIBUTE: 
            case SERVER_ATTRIBUTE: {
                result |= this.putIfKeyExists(key, value, updateOfTs);
                result |= this.putIfKeyExists(this.getAttrKey(key, EntityKeyType.ATTRIBUTE), value, updateOfTs);
                break;
            }
            default: {
                result |= this.putIfKeyExists(key, value, updateOfTs);
            }
        }
        return result;
    }

    private boolean putIfKeyExists(EntityKey key, EntityKeyValue value, boolean updateOfTs) {
        if (this.keys.contains(key)) {
            EntityKeyValue oldValue = this.values.put(key, value);
            if (updateOfTs) {
                return true;
            }
            return oldValue == null || !oldValue.equals(value);
        }
        return false;
    }

    EntityKeyValue getValue(EntityKey key) {
        if (EntityKeyType.ATTRIBUTE.equals((Object)key.getType())) {
            EntityKeyValue value = this.values.get(key);
            if (value == null && (value = this.values.get(this.getAttrKey(key, EntityKeyType.CLIENT_ATTRIBUTE))) == null && (value = this.values.get(this.getAttrKey(key, EntityKeyType.SHARED_ATTRIBUTE))) == null) {
                value = this.values.get(this.getAttrKey(key, EntityKeyType.SERVER_ATTRIBUTE));
            }
            return value;
        }
        return this.values.get(key);
    }

    private EntityKey getAttrKey(EntityKey key, EntityKeyType clientAttribute) {
        return new EntityKey(clientAttribute, key.getKey());
    }

    public long getTs() {
        return this.ts;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }
}

