/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.profile;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.action.TbAlarmResult;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.profile.AlarmEvalResult;
import org.thingsboard.rule.engine.profile.AlarmRuleState;
import org.thingsboard.rule.engine.profile.DataSnapshot;
import org.thingsboard.rule.engine.profile.EntityKeyValue;
import org.thingsboard.rule.engine.profile.ProfileState;
import org.thingsboard.rule.engine.profile.SnapshotUpdate;
import org.thingsboard.rule.engine.profile.state.PersistedAlarmRuleState;
import org.thingsboard.rule.engine.profile.state.PersistedAlarmState;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.alarm.AlarmStatus;
import org.thingsboard.server.common.data.device.profile.AlarmRule;
import org.thingsboard.server.common.data.device.profile.DeviceProfileAlarm;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.query.KeyFilter;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.dao.util.mapping.JacksonUtil;

class AlarmState {
    private static final Logger log = LoggerFactory.getLogger(AlarmState.class);
    private final ProfileState deviceProfile;
    private final EntityId originator;
    private DeviceProfileAlarm alarmDefinition;
    private volatile List<AlarmRuleState> createRulesSortedBySeverityDesc;
    private volatile AlarmRuleState clearState;
    private volatile Alarm currentAlarm;
    private volatile boolean initialFetchDone;
    private volatile TbMsgMetaData lastMsgMetaData;
    private volatile String lastMsgQueueName;
    private volatile DataSnapshot dataSnapshot;

    AlarmState(ProfileState deviceProfile, EntityId originator, DeviceProfileAlarm alarmDefinition, PersistedAlarmState alarmState) {
        this.deviceProfile = deviceProfile;
        this.originator = originator;
        this.updateState(alarmDefinition, alarmState);
    }

    public boolean process(TbContext ctx, TbMsg msg, DataSnapshot data, SnapshotUpdate update) throws ExecutionException, InterruptedException {
        this.initCurrentAlarm(ctx);
        this.lastMsgMetaData = msg.getMetaData();
        this.lastMsgQueueName = msg.getQueueName();
        this.dataSnapshot = data;
        return this.createOrClearAlarms(ctx, data, update, AlarmRuleState::eval);
    }

    public boolean process(TbContext ctx, long ts) throws ExecutionException, InterruptedException {
        this.initCurrentAlarm(ctx);
        return this.createOrClearAlarms(ctx, ts, null, AlarmRuleState::eval);
    }

    public <T> boolean createOrClearAlarms(TbContext ctx, T data, SnapshotUpdate update, BiFunction<AlarmRuleState, T, AlarmEvalResult> evalFunction) {
        boolean stateUpdate = false;
        AlarmRuleState resultState = null;
        log.debug("[{}] processing update: {}", (Object)this.alarmDefinition.getId(), data);
        for (AlarmRuleState state : this.createRulesSortedBySeverityDesc) {
            if (!this.validateUpdate(update, state)) {
                log.debug("[{}][{}] Update is not valid for current rule state", (Object)this.alarmDefinition.getId(), (Object)state.getSeverity());
                continue;
            }
            AlarmEvalResult evalResult = evalFunction.apply(state, (AlarmRuleState)data);
            stateUpdate |= state.checkUpdate();
            if (AlarmEvalResult.TRUE.equals((Object)evalResult)) {
                resultState = state;
                break;
            }
            if (!AlarmEvalResult.FALSE.equals((Object)evalResult)) continue;
            stateUpdate = this.clearAlarmState(stateUpdate, state);
        }
        if (resultState != null) {
            TbAlarmResult result = this.calculateAlarmResult(ctx, resultState);
            if (result != null) {
                this.pushMsg(ctx, result);
            }
            stateUpdate = this.clearAlarmState(stateUpdate, this.clearState);
        } else if (this.currentAlarm != null && this.clearState != null) {
            if (!this.validateUpdate(update, this.clearState)) {
                log.debug("[{}] Update is not valid for current clear state", (Object)this.alarmDefinition.getId());
                return stateUpdate;
            }
            AlarmEvalResult evalResult = evalFunction.apply(this.clearState, (AlarmRuleState)data);
            if (AlarmEvalResult.TRUE.equals((Object)evalResult)) {
                stateUpdate = this.clearAlarmState(stateUpdate, this.clearState);
                for (AlarmRuleState state : this.createRulesSortedBySeverityDesc) {
                    stateUpdate = this.clearAlarmState(stateUpdate, state);
                }
                ctx.getAlarmService().clearAlarm(ctx.getTenantId(), (AlarmId)this.currentAlarm.getId(), this.createDetails(this.clearState), System.currentTimeMillis());
                this.pushMsg(ctx, new TbAlarmResult(false, false, true, this.currentAlarm));
                this.currentAlarm = null;
            } else if (AlarmEvalResult.FALSE.equals((Object)evalResult)) {
                stateUpdate = this.clearAlarmState(stateUpdate, this.clearState);
            }
        }
        return stateUpdate;
    }

    public boolean clearAlarmState(boolean stateUpdate, AlarmRuleState state) {
        if (state != null) {
            state.clear();
            stateUpdate |= state.checkUpdate();
        }
        return stateUpdate;
    }

    public boolean validateUpdate(SnapshotUpdate update, AlarmRuleState state) {
        if (update != null) {
            if (update.getType().equals((Object)EntityKeyType.TIME_SERIES)) {
                return state.validateTsUpdate(update.getKeys());
            }
            if (update.getType().equals((Object)EntityKeyType.ATTRIBUTE)) {
                return state.validateAttrUpdate(update.getKeys());
            }
        }
        return true;
    }

    public void initCurrentAlarm(TbContext ctx) throws InterruptedException, ExecutionException {
        if (!this.initialFetchDone) {
            Alarm alarm = (Alarm)ctx.getAlarmService().findLatestByOriginatorAndType(ctx.getTenantId(), this.originator, this.alarmDefinition.getAlarmType()).get();
            if (alarm != null && !alarm.getStatus().isCleared()) {
                this.currentAlarm = alarm;
            }
            this.initialFetchDone = true;
        }
    }

    public void pushMsg(TbContext ctx, TbAlarmResult alarmResult) {
        String relationType;
        TbMsgMetaData metaData;
        JsonNode jsonNodes = JacksonUtil.valueToTree((Object)alarmResult.getAlarm());
        String data = jsonNodes.toString();
        TbMsgMetaData tbMsgMetaData = metaData = this.lastMsgMetaData != null ? this.lastMsgMetaData.copy() : new TbMsgMetaData();
        if (alarmResult.isCreated()) {
            relationType = "Alarm Created";
            metaData.putValue("isNewAlarm", Boolean.TRUE.toString());
        } else if (alarmResult.isUpdated()) {
            relationType = "Alarm Updated";
            metaData.putValue("isExistingAlarm", Boolean.TRUE.toString());
        } else if (alarmResult.isSeverityUpdated()) {
            relationType = "Alarm Severity Updated";
            metaData.putValue("isExistingAlarm", Boolean.TRUE.toString());
            metaData.putValue("isSeverityUpdated", Boolean.TRUE.toString());
        } else {
            relationType = "Alarm Cleared";
            metaData.putValue("isClearedAlarm", Boolean.TRUE.toString());
        }
        TbMsg newMsg = ctx.newMsg(this.lastMsgQueueName != null ? this.lastMsgQueueName : "Main", "ALARM", this.originator, metaData, data);
        ctx.tellNext(newMsg, relationType);
    }

    public void updateState(DeviceProfileAlarm alarm, PersistedAlarmState alarmState) {
        PersistedAlarmRuleState ruleState;
        this.alarmDefinition = alarm;
        this.createRulesSortedBySeverityDesc = new ArrayList<AlarmRuleState>();
        this.alarmDefinition.getCreateRules().forEach((severity, rule) -> {
            PersistedAlarmRuleState ruleState = null;
            if (alarmState != null && (ruleState = alarmState.getCreateRuleStates().get(severity)) == null) {
                ruleState = new PersistedAlarmRuleState();
                alarmState.getCreateRuleStates().put((AlarmSeverity)severity, ruleState);
            }
            this.createRulesSortedBySeverityDesc.add(new AlarmRuleState((AlarmSeverity)severity, (AlarmRule)rule, this.deviceProfile.getCreateAlarmKeys(alarm.getId(), (AlarmSeverity)severity), ruleState));
        });
        this.createRulesSortedBySeverityDesc.sort(Comparator.comparingInt(state -> state.getSeverity().ordinal()));
        PersistedAlarmRuleState persistedAlarmRuleState = ruleState = alarmState == null ? null : alarmState.getClearRuleState();
        if (this.alarmDefinition.getClearRule() != null) {
            this.clearState = new AlarmRuleState(null, this.alarmDefinition.getClearRule(), this.deviceProfile.getClearAlarmKeys(alarm.getId()), ruleState);
        }
    }

    private TbAlarmResult calculateAlarmResult(TbContext ctx, AlarmRuleState ruleState) {
        AlarmSeverity severity = ruleState.getSeverity();
        if (this.currentAlarm != null) {
            this.currentAlarm.setEndTs(System.currentTimeMillis());
            AlarmSeverity oldSeverity = this.currentAlarm.getSeverity();
            if (severity.ordinal() <= oldSeverity.ordinal()) {
                this.currentAlarm.setDetails(this.createDetails(ruleState));
                if (!oldSeverity.equals((Object)severity)) {
                    this.currentAlarm.setSeverity(severity);
                    this.currentAlarm = ctx.getAlarmService().createOrUpdateAlarm(this.currentAlarm);
                    return new TbAlarmResult(false, false, true, false, this.currentAlarm);
                }
                this.currentAlarm = ctx.getAlarmService().createOrUpdateAlarm(this.currentAlarm);
                return new TbAlarmResult(false, true, false, false, this.currentAlarm);
            }
            return null;
        }
        this.currentAlarm = new Alarm();
        this.currentAlarm.setType(this.alarmDefinition.getAlarmType());
        this.currentAlarm.setStatus(AlarmStatus.ACTIVE_UNACK);
        this.currentAlarm.setSeverity(severity);
        this.currentAlarm.setStartTs(System.currentTimeMillis());
        this.currentAlarm.setEndTs(this.currentAlarm.getStartTs());
        this.currentAlarm.setDetails(this.createDetails(ruleState));
        this.currentAlarm.setOriginator(this.originator);
        this.currentAlarm.setTenantId(ctx.getTenantId());
        this.currentAlarm.setPropagate(this.alarmDefinition.isPropagate());
        if (this.alarmDefinition.getPropagateRelationTypes() != null) {
            this.currentAlarm.setPropagateRelationTypes(this.alarmDefinition.getPropagateRelationTypes());
        }
        this.currentAlarm = ctx.getAlarmService().createOrUpdateAlarm(this.currentAlarm);
        boolean updated = this.currentAlarm.getStartTs() != this.currentAlarm.getEndTs();
        return new TbAlarmResult(!updated, updated, false, false, this.currentAlarm);
    }

    private JsonNode createDetails(AlarmRuleState ruleState) {
        Object alarmDetails;
        String alarmDetailsStr = ruleState.getAlarmRule().getAlarmDetails();
        if (StringUtils.isNotEmpty((CharSequence)alarmDetailsStr)) {
            for (KeyFilter keyFilter : ruleState.getAlarmRule().getCondition().getCondition()) {
                EntityKeyValue entityKeyValue = this.dataSnapshot.getValue(keyFilter.getKey());
                alarmDetailsStr = alarmDetailsStr.replaceAll(String.format("\\$\\{%s}", keyFilter.getKey().getKey()), AlarmState.getValueAsString(entityKeyValue));
            }
            ObjectNode newDetails = JacksonUtil.newObjectNode();
            newDetails.put("data", alarmDetailsStr);
            alarmDetails = newDetails;
        } else {
            alarmDetails = this.currentAlarm != null ? this.currentAlarm.getDetails() : JacksonUtil.newObjectNode();
        }
        return alarmDetails;
    }

    private static String getValueAsString(EntityKeyValue entityKeyValue) {
        Object result = null;
        switch (entityKeyValue.getDataType()) {
            case STRING: {
                result = entityKeyValue.getStrValue();
                break;
            }
            case JSON: {
                result = entityKeyValue.getJsonValue();
                break;
            }
            case LONG: {
                result = entityKeyValue.getLngValue();
                break;
            }
            case DOUBLE: {
                result = entityKeyValue.getDblValue();
                break;
            }
            case BOOLEAN: {
                result = entityKeyValue.getBoolValue();
            }
        }
        return String.valueOf(result);
    }

    public boolean processAlarmClear(TbContext ctx, Alarm alarmNf) {
        boolean updated = false;
        if (this.currentAlarm != null && ((AlarmId)this.currentAlarm.getId()).equals((Object)alarmNf.getId())) {
            this.currentAlarm = null;
            for (AlarmRuleState state : this.createRulesSortedBySeverityDesc) {
                updated = this.clearAlarmState(updated, state);
            }
        }
        return updated;
    }

    public void processAckAlarm(Alarm alarm) {
        if (this.currentAlarm != null && ((AlarmId)this.currentAlarm.getId()).equals((Object)alarm.getId())) {
            this.currentAlarm.setStatus(alarm.getStatus());
            this.currentAlarm.setAckTs(alarm.getAckTs());
        }
    }

    public ProfileState getDeviceProfile() {
        return this.deviceProfile;
    }

    public EntityId getOriginator() {
        return this.originator;
    }

    public DeviceProfileAlarm getAlarmDefinition() {
        return this.alarmDefinition;
    }

    public List<AlarmRuleState> getCreateRulesSortedBySeverityDesc() {
        return this.createRulesSortedBySeverityDesc;
    }

    public AlarmRuleState getClearState() {
        return this.clearState;
    }

    public Alarm getCurrentAlarm() {
        return this.currentAlarm;
    }

    public boolean isInitialFetchDone() {
        return this.initialFetchDone;
    }

    public TbMsgMetaData getLastMsgMetaData() {
        return this.lastMsgMetaData;
    }

    public String getLastMsgQueueName() {
        return this.lastMsgQueueName;
    }

    public DataSnapshot getDataSnapshot() {
        return this.dataSnapshot;
    }

    public void setAlarmDefinition(DeviceProfileAlarm alarmDefinition) {
        this.alarmDefinition = alarmDefinition;
    }

    public void setCreateRulesSortedBySeverityDesc(List<AlarmRuleState> createRulesSortedBySeverityDesc) {
        this.createRulesSortedBySeverityDesc = createRulesSortedBySeverityDesc;
    }

    public void setClearState(AlarmRuleState clearState) {
        this.clearState = clearState;
    }

    public void setCurrentAlarm(Alarm currentAlarm) {
        this.currentAlarm = currentAlarm;
    }

    public void setInitialFetchDone(boolean initialFetchDone) {
        this.initialFetchDone = initialFetchDone;
    }

    public void setLastMsgMetaData(TbMsgMetaData lastMsgMetaData) {
        this.lastMsgMetaData = lastMsgMetaData;
    }

    public void setLastMsgQueueName(String lastMsgQueueName) {
        this.lastMsgQueueName = lastMsgQueueName;
    }

    public void setDataSnapshot(DataSnapshot dataSnapshot) {
        this.dataSnapshot = dataSnapshot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmState)) {
            return false;
        }
        AlarmState other = (AlarmState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProfileState this$deviceProfile = this.getDeviceProfile();
        ProfileState other$deviceProfile = other.getDeviceProfile();
        if (this$deviceProfile == null ? other$deviceProfile != null : !this$deviceProfile.equals(other$deviceProfile)) {
            return false;
        }
        EntityId this$originator = this.getOriginator();
        EntityId other$originator = other.getOriginator();
        if (this$originator == null ? other$originator != null : !this$originator.equals(other$originator)) {
            return false;
        }
        DeviceProfileAlarm this$alarmDefinition = this.getAlarmDefinition();
        DeviceProfileAlarm other$alarmDefinition = other.getAlarmDefinition();
        if (this$alarmDefinition == null ? other$alarmDefinition != null : !this$alarmDefinition.equals(other$alarmDefinition)) {
            return false;
        }
        List<AlarmRuleState> this$createRulesSortedBySeverityDesc = this.getCreateRulesSortedBySeverityDesc();
        List<AlarmRuleState> other$createRulesSortedBySeverityDesc = other.getCreateRulesSortedBySeverityDesc();
        if (this$createRulesSortedBySeverityDesc == null ? other$createRulesSortedBySeverityDesc != null : !((Object)this$createRulesSortedBySeverityDesc).equals(other$createRulesSortedBySeverityDesc)) {
            return false;
        }
        AlarmRuleState this$clearState = this.getClearState();
        AlarmRuleState other$clearState = other.getClearState();
        if (this$clearState == null ? other$clearState != null : !((Object)this$clearState).equals(other$clearState)) {
            return false;
        }
        Alarm this$currentAlarm = this.getCurrentAlarm();
        Alarm other$currentAlarm = other.getCurrentAlarm();
        if (this$currentAlarm == null ? other$currentAlarm != null : !this$currentAlarm.equals(other$currentAlarm)) {
            return false;
        }
        if (this.isInitialFetchDone() != other.isInitialFetchDone()) {
            return false;
        }
        TbMsgMetaData this$lastMsgMetaData = this.getLastMsgMetaData();
        TbMsgMetaData other$lastMsgMetaData = other.getLastMsgMetaData();
        if (this$lastMsgMetaData == null ? other$lastMsgMetaData != null : !this$lastMsgMetaData.equals(other$lastMsgMetaData)) {
            return false;
        }
        String this$lastMsgQueueName = this.getLastMsgQueueName();
        String other$lastMsgQueueName = other.getLastMsgQueueName();
        if (this$lastMsgQueueName == null ? other$lastMsgQueueName != null : !this$lastMsgQueueName.equals(other$lastMsgQueueName)) {
            return false;
        }
        DataSnapshot this$dataSnapshot = this.getDataSnapshot();
        DataSnapshot other$dataSnapshot = other.getDataSnapshot();
        return !(this$dataSnapshot == null ? other$dataSnapshot != null : !this$dataSnapshot.equals(other$dataSnapshot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProfileState $deviceProfile = this.getDeviceProfile();
        result = result * 59 + ($deviceProfile == null ? 43 : $deviceProfile.hashCode());
        EntityId $originator = this.getOriginator();
        result = result * 59 + ($originator == null ? 43 : $originator.hashCode());
        DeviceProfileAlarm $alarmDefinition = this.getAlarmDefinition();
        result = result * 59 + ($alarmDefinition == null ? 43 : $alarmDefinition.hashCode());
        List<AlarmRuleState> $createRulesSortedBySeverityDesc = this.getCreateRulesSortedBySeverityDesc();
        result = result * 59 + ($createRulesSortedBySeverityDesc == null ? 43 : ((Object)$createRulesSortedBySeverityDesc).hashCode());
        AlarmRuleState $clearState = this.getClearState();
        result = result * 59 + ($clearState == null ? 43 : ((Object)$clearState).hashCode());
        Alarm $currentAlarm = this.getCurrentAlarm();
        result = result * 59 + ($currentAlarm == null ? 43 : $currentAlarm.hashCode());
        result = result * 59 + (this.isInitialFetchDone() ? 79 : 97);
        TbMsgMetaData $lastMsgMetaData = this.getLastMsgMetaData();
        result = result * 59 + ($lastMsgMetaData == null ? 43 : $lastMsgMetaData.hashCode());
        String $lastMsgQueueName = this.getLastMsgQueueName();
        result = result * 59 + ($lastMsgQueueName == null ? 43 : $lastMsgQueueName.hashCode());
        DataSnapshot $dataSnapshot = this.getDataSnapshot();
        result = result * 59 + ($dataSnapshot == null ? 43 : $dataSnapshot.hashCode());
        return result;
    }

    public String toString() {
        return "AlarmState(deviceProfile=" + this.getDeviceProfile() + ", originator=" + this.getOriginator() + ", alarmDefinition=" + this.getAlarmDefinition() + ", createRulesSortedBySeverityDesc=" + this.getCreateRulesSortedBySeverityDesc() + ", clearState=" + this.getClearState() + ", currentAlarm=" + this.getCurrentAlarm() + ", initialFetchDone=" + this.isInitialFetchDone() + ", lastMsgMetaData=" + this.getLastMsgMetaData() + ", lastMsgQueueName=" + this.getLastMsgQueueName() + ", dataSnapshot=" + this.getDataSnapshot() + ")";
    }
}

