/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractGetEntityDetailsNode;
import org.thingsboard.rule.engine.metadata.TbGetTenantDetailsNodeConfiguration;
import org.thingsboard.server.common.data.ContactBased;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ENRICHMENT, name="tenant details", configClazz=TbGetTenantDetailsNodeConfiguration.class, nodeDescription="Adds fields from Tenant details to the message body or metadata", nodeDetails="If checkbox: <b>Add selected details to the message metadata</b> is selected, existing fields will be added to the message metadata instead of message data.<br><br><b>Note:</b> only Device, Asset, and Entity View type are allowed.<br><br>If the originator of the message is not assigned to Tenant, or originator type is not supported - Message will be forwarded to <b>Failure</b> chain, otherwise, <b>Success</b> chain will be used.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeEntityDetailsConfig")
public class TbGetTenantDetailsNode
extends TbAbstractGetEntityDetailsNode<TbGetTenantDetailsNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbGetTenantDetailsNode.class);
    private static final String TENANT_PREFIX = "tenant_";

    @Override
    protected TbGetTenantDetailsNodeConfiguration loadGetEntityDetailsNodeConfiguration(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbGetTenantDetailsNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetTenantDetailsNodeConfiguration.class);
    }

    @Override
    protected ListenableFuture<TbMsg> getDetails(TbContext ctx, TbMsg msg) {
        return this.getTbMsgListenableFuture(ctx, msg, this.getDataAsJson(msg), TENANT_PREFIX);
    }

    @Override
    protected ListenableFuture<ContactBased> getContactBasedListenableFuture(TbContext ctx, TbMsg msg) {
        return Futures.transformAsync((ListenableFuture)ctx.getTenantService().findTenantByIdAsync(ctx.getTenantId(), ctx.getTenantId()), tenant -> {
            if (tenant != null) {
                return Futures.immediateFuture((Object)tenant);
            }
            return Futures.immediateFuture(null);
        }, (Executor)MoreExecutors.directExecutor());
    }
}

