/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.TbRelationTypes;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbGetEntityAttrNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.msg.TbMsg;

public abstract class TbEntityGetAttrNode<T extends EntityId>
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbEntityGetAttrNode.class);
    private TbGetEntityAttrNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbGetEntityAttrNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetEntityAttrNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        try {
            DonAsynchron.withCallback(this.findEntityAsync(ctx, msg.getOriginator()), entityId -> this.safeGetAttributes(ctx, msg, entityId), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
        }
        catch (Throwable th) {
            ctx.tellFailure(msg, th);
        }
    }

    private void safeGetAttributes(TbContext ctx, TbMsg msg, T entityId) {
        if (entityId == null || entityId.isNullUid()) {
            ctx.tellNext(msg, TbRelationTypes.FAILURE);
            return;
        }
        DonAsynchron.withCallback(this.config.isTelemetry() ? this.getLatestTelemetry(ctx, (EntityId)entityId) : this.getAttributesAsync(ctx, (EntityId)entityId), attributes -> this.putAttributesAndTell(ctx, msg, (List<? extends KvEntry>)attributes), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<List<KvEntry>> getAttributesAsync(TbContext ctx, EntityId entityId) {
        ListenableFuture latest = ctx.getAttributesService().find(ctx.getTenantId(), entityId, "SERVER_SCOPE", this.config.getAttrMapping().keySet());
        return Futures.transform((ListenableFuture)latest, l -> l.stream().map(i -> i).collect(Collectors.toList()), (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<List<KvEntry>> getLatestTelemetry(TbContext ctx, EntityId entityId) {
        ListenableFuture latest = ctx.getTimeseriesService().findLatest(ctx.getTenantId(), entityId, this.config.getAttrMapping().keySet());
        return Futures.transform((ListenableFuture)latest, l -> l.stream().map(i -> i).collect(Collectors.toList()), (Executor)MoreExecutors.directExecutor());
    }

    private void putAttributesAndTell(TbContext ctx, TbMsg msg, List<? extends KvEntry> attributes) {
        attributes.forEach(r -> {
            String attrName = this.config.getAttrMapping().get(r.getKey());
            msg.getMetaData().putValue(attrName, r.getValueAsString());
        });
        ctx.tellSuccess(msg);
    }

    public void destroy() {
    }

    protected abstract ListenableFuture<T> findEntityAsync(TbContext var1, EntityId var2);

    public void setConfig(TbGetEntityAttrNodeConfiguration config) {
        this.config = config;
    }
}

